package org.kie.kogito.rules.alerting;

import org.drools.core.RuleBaseConfiguration;
import org.drools.core.SessionConfigurationImpl;
import org.drools.core.impl.EnvironmentImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.modelcompiler.builder.KieBaseBuilder;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.runtime.KieSession;

@javax.inject.Singleton()
public class LoggerServiceRuleUnit extends org.kie.kogito.rules.impl.AbstractRuleUnit<LoggerService> {

    private final InternalKnowledgeBase kbase;

    public LoggerServiceRuleUnit() {
        this(new org.kie.kogito.examples.Application());
    }

    @javax.inject.Inject()
    public LoggerServiceRuleUnit(org.kie.kogito.Application app) {
        super(app);
        this.kbase = createKieBase();
    }

    public org.kie.kogito.rules.alerting.LoggerServiceRuleUnitInstance createInstance(LoggerService value) {
        return new org.kie.kogito.rules.alerting.LoggerServiceRuleUnitInstance(this, value, createLegacySession());
    }

    private InternalKnowledgeBase createKieBase() {
        if (app.config() != null && app.config().rule() != null) {
            org.kie.kogito.rules.RuleConfig ruleCfg = app.config().rule();
            KieBaseConfiguration kieBaseConfiguration = new RuleBaseConfiguration();
            kieBaseConfiguration.setOption(ruleCfg.eventProcessingMode());
            return KieBaseBuilder.createKieBaseFromModel(new org.kie.kogito.rules.alerting.Rules4723952D402A230BDB0E7081EBBA10E2_LoggerService(), kieBaseConfiguration);
        } else {
            return KieBaseBuilder.createKieBaseFromModel(new org.kie.kogito.rules.alerting.Rules4723952D402A230BDB0E7081EBBA10E2_LoggerService());
        }
    }

    private org.kie.api.runtime.KieSession createLegacySession() {
        if (app.config() != null && app.config().rule() != null) {
            org.kie.kogito.rules.RuleConfig ruleCfg = app.config().rule();
            SessionConfigurationImpl sessionConfiguration = new SessionConfigurationImpl();
            sessionConfiguration.setOption(ruleCfg.clockType());
            KieSession ks = kbase.newKieSession(sessionConfiguration, new EnvironmentImpl());
            org.kie.kogito.rules.RuleEventListenerConfig ruleEventListenerConfig = ruleCfg.ruleEventListeners();
            ruleEventListenerConfig.agendaListeners().forEach(ks::addEventListener);
            ruleEventListenerConfig.ruleRuntimeListeners().forEach(ks::addEventListener);
            return ks;
        } else {
            return kbase.newKieSession();
        }
    }
}
