package org.kie.kogito.candrink;

import org.kie.api.runtime.KieSession;
import org.kie.kogito.rules.RuleEventListenerConfig;
import org.kie.kogito.rules.units.impl.AbstractRuleUnit;

@javax.inject.Singleton()
public class CanDrinkUnitRuleUnit extends AbstractRuleUnit<CanDrinkUnit> {

    public CanDrinkUnitRuleUnit() {
        this(new org.kie.kogito.examples.Application());
    }

    @javax.inject.Inject()
    public CanDrinkUnitRuleUnit(org.kie.kogito.Application app) {
        super(app);
    }

    public org.kie.kogito.candrink.CanDrinkUnitRuleUnitInstance internalCreateInstance(CanDrinkUnit value) {
        return new org.kie.kogito.candrink.CanDrinkUnitRuleUnitInstance(this, value, createLegacySession());
    }

    private KieSession createLegacySession() {
        KieSession ks = app.ruleUnits().ruleRuntimeBuilder().newKieSession(CanDrinkUnit.class);
        ((org.drools.core.impl.StatefulKnowledgeSessionImpl) ks).setApplication(app);
        if (app.config() != null && app.config().rule() != null) {
            RuleEventListenerConfig ruleEventListenerConfig = app.config().rule().ruleEventListeners();
            ruleEventListenerConfig.agendaListeners().forEach(ks::addEventListener);
            ruleEventListenerConfig.ruleRuntimeListeners().forEach(ks::addEventListener);
        }
        return ks;
    }
}
