/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.kogito.Application;
import org.kie.kogito.examples.hr.EmployeeValidationModel;
import org.kie.kogito.rules.KieRuntimeBuilder;

@Path(value="/employeeValidation")
public class ValidationEndpoint {
    @Inject
    KieRuntimeBuilder runtimeBuilder;
    @Inject
    Application app;
    KieSession ksession;

    @PostConstruct
    public void setup() {
        this.ksession = this.runtimeBuilder.newKieSession("defaultKieSession", this.app.config().rule());
    }

    @PreDestroy
    public void cleanup() {
        this.ksession.dispose();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public EmployeeValidationModel validateEmployee(final EmployeeValidationModel resource) {
        this.ksession.insert((Object)resource.getEmployee());
        this.ksession.fireAllRules();
        Collection found = this.ksession.getObjects(new ObjectFilter(){

            public boolean accept(Object object) {
                return object instanceof EmployeeValidationModel && ((EmployeeValidationModel)object).getEmployee().getPersonalId().equals(resource.getEmployee().getPersonalId());
            }
        });
        return (EmployeeValidationModel)found.iterator().next();
    }
}

