package org.kie.kogito.examples;

import org.kie.kogito.Config;
import org.kie.kogito.process.Processes;
import org.kie.kogito.uow.UnitOfWorkManager;

@javax.inject.Singleton()
public class Application implements org.kie.kogito.Application {

    @javax.inject.Inject()
    javax.enterprise.inject.Instance<org.kie.kogito.event.EventPublisher> eventPublishers;

    @javax.inject.Inject()
    org.kie.kogito.Config config;

    RuleUnits ruleUnits = new RuleUnits();

    public Config config() {
        return config;
    }

    public UnitOfWorkManager unitOfWorkManager() {
        return config().process().unitOfWorkManager();
    }

    @javax.annotation.PostConstruct()
    public void setup() {
        if (eventPublishers != null) {
            eventPublishers.forEach(publisher -> unitOfWorkManager().eventManager().addPublisher(publisher));
        }
    }

    public RuleUnits ruleUnits() {
        return ruleUnits;
    }

    public class RuleUnits implements org.kie.kogito.rules.RuleUnits {

        org.kie.kogito.rules.KieRuntimeBuilder ruleRuntimeBuilder = new org.drools.project.model.ProjectRuntime();

        public org.kie.kogito.rules.KieRuntimeBuilder ruleRuntimeBuilder() {
            return this.ruleRuntimeBuilder;
        }
    }
}
