package org.kie.kogito.examples.hr;

import java.util.*;
import org.drools.model.*;
import org.drools.modelcompiler.dsl.pattern.D;
import org.drools.model.Index.ConstraintType;
import java.time.*;
import java.time.format.*;
import java.text.*;
import org.drools.core.util.*;
import static org.kie.kogito.examples.hr.Rules209B5B6C799211C5A86114EBA882CF32.*;

public class Rules209B5B6C799211C5A86114EBA882CF32RuleMethods0 {

    /**
     * Rule name: Employee exists
     */
    public static org.drools.model.Rule rule_Employee_32exists() {
        final org.drools.model.Variable<org.kie.kogito.examples.hr.Employee> var_$emp = D.declarationOf(org.kie.kogito.examples.hr.Employee.class,
                                                                                                        DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_Employee_Metadata_INSTANCE,
                                                                                                        "$emp");
        final org.drools.model.Variable<org.kie.kogito.examples.hr.EmployeeValidationModel> var_$val = D.declarationOf(org.kie.kogito.examples.hr.EmployeeValidationModel.class,
                                                                                                                       DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_EmployeeValidationModel_Metadata_INSTANCE,
                                                                                                                       "$val");
        final org.drools.model.BitMask mask_$val = org.drools.model.BitMask.getPatternMask(DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_EmployeeValidationModel_Metadata_INSTANCE,
                                                                                           "message",
                                                                                           "employee",
                                                                                           "status");
        org.drools.model.Rule rule = D.rule("org.kie.kogito.examples.hr",
                                            "Employee exists").build(D.pattern(var_$emp).watch("personalId"),
                                                                     D.pattern(var_$val).expr("CF3518871746A846ECAEDD95FCEC2767",
                                                                                              var_$emp,
                                                                                              (_this, $emp) -> org.drools.modelcompiler.util.EvaluationUtil.areNullSafeEquals($emp.getPersonalId(),
                                                                                                                                                                              _this.getEmployee().getPersonalId()),
                                                                                              D.reactOn("employee")),
                                                                     D.on(var_$emp,
                                                                          var_$val).execute((drools, $emp, $val) -> {
                                                                         {
                                                                             drools.delete($emp);
                                                                             ($val).setStatus("exists");
                                                                             ($val).setMessage("Employee " + $val.getEmployee()
                                                                                                                 .getFirstName() + " " + $val.getEmployee()
                                                                                                                                             .getLastName() + " is already registered");
                                                                             drools.update($val,
                                                                                           mask_$val);
                                                                         }
                                                                     }));
        return rule;
    }

    /**
     * Rule name: Employee does not exist
     */
    public static org.drools.model.Rule rule_Employee_32does_32not_32exist() {
        final org.drools.model.Variable<org.kie.kogito.examples.hr.Employee> var_$emp = D.declarationOf(org.kie.kogito.examples.hr.Employee.class,
                                                                                                        DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_Employee_Metadata_INSTANCE,
                                                                                                        "$emp");
        final org.drools.model.Variable<org.kie.kogito.examples.hr.EmployeeValidationModel> var_sCoPe1__GENERATED_$pattern_EmployeeValidationModel$1$ = D.declarationOf(org.kie.kogito.examples.hr.EmployeeValidationModel.class,
                                                                                                                                                                        DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_EmployeeValidationModel_Metadata_INSTANCE,
                                                                                                                                                                        "sCoPe1__GENERATED_$pattern_EmployeeValidationModel$1$");
        org.drools.model.Rule rule = D.rule("org.kie.kogito.examples.hr",
                                            "Employee does not exist").build(D.pattern(var_$emp).watch("personalId"),
                                                                             D.not(D.pattern(var_sCoPe1__GENERATED_$pattern_EmployeeValidationModel$1$).expr("CF3518871746A846ECAEDD95FCEC2767",
                                                                                                                                                             var_$emp,
                                                                                                                                                             (_this, $emp) -> org.drools.modelcompiler.util.EvaluationUtil.areNullSafeEquals($emp.getPersonalId(),
                                                                                                                                                                                                                                             _this.getEmployee().getPersonalId()),
                                                                                                                                                             D.reactOn("employee"))),
                                                                             D.on(var_$emp).execute((drools, $emp) -> {
                                                                                 EmployeeValidationModel val = new EmployeeValidationModel();
                                                                                 val.setEmployee($emp);
                                                                                 val.setStatus("new");
                                                                                 val.setMessage("Employee " + $emp.getFirstName() + " " + $emp.getLastName() + " is not yet registered");
                                                                                 drools.delete($emp);
                                                                                 drools.insert(val);
                                                                             }));
        return rule;
    }

    /**
     * Rule name: US Employee
     */
    public static org.drools.model.Rule rule_US_32Employee() {
        final org.drools.model.Variable<org.kie.kogito.examples.hr.DepartmentModel> var_$d = D.declarationOf(org.kie.kogito.examples.hr.DepartmentModel.class,
                                                                                                             DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_DepartmentModel_Metadata_INSTANCE,
                                                                                                             "$d");
        final org.drools.model.BitMask mask_$d = org.drools.model.BitMask.getPatternMask(DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_DepartmentModel_Metadata_INSTANCE,
                                                                                         "department");
        org.drools.model.Rule rule = D.rule("org.kie.kogito.examples.hr",
                                            "US Employee").build(D.pattern(var_$d).expr("D05E92EAF7E0CA366D521438A3495826",
                                                                                        (_this) -> org.drools.modelcompiler.util.EvaluationUtil.areNullSafeEquals(_this.getEmployee()
                                                                                                                                                                       .getAddress()
                                                                                                                                                                       .getCountry(),
                                                                                                                                                                  "US"),
                                                                                        D.alphaIndexedBy(java.lang.String.class,
                                                                                                         org.drools.model.Index.ConstraintType.EQUAL,
                                                                                                         -1,
                                                                                                         _this -> _this.getEmployee()
                                                                                                                       .getAddress()
                                                                                                                       .getCountry(),
                                                                                                         "US"),
                                                                                        D.reactOn("employee")),
                                                                 D.on(var_$d).execute((drools, $d) -> {
                                                                     {
                                                                         ($d).setDepartment("US12345");
                                                                         drools.update($d,
                                                                                       mask_$d);
                                                                     }
                                                                 }));
        return rule;
    }

    /**
     * Rule name: UK Employee
     */
    public static org.drools.model.Rule rule_UK_32Employee() {
        final org.drools.model.Variable<org.kie.kogito.examples.hr.DepartmentModel> var_$d = D.declarationOf(org.kie.kogito.examples.hr.DepartmentModel.class,
                                                                                                             DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_DepartmentModel_Metadata_INSTANCE,
                                                                                                             "$d");
        final org.drools.model.BitMask mask_$d = org.drools.model.BitMask.getPatternMask(DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_DepartmentModel_Metadata_INSTANCE,
                                                                                         "department");
        org.drools.model.Rule rule = D.rule("org.kie.kogito.examples.hr",
                                            "UK Employee").build(D.pattern(var_$d).expr("F02DD8AC66392E172ACC15450D74A344",
                                                                                        (_this) -> org.drools.modelcompiler.util.EvaluationUtil.areNullSafeEquals(_this.getEmployee()
                                                                                                                                                                       .getAddress()
                                                                                                                                                                       .getCountry(),
                                                                                                                                                                  "UK"),
                                                                                        D.alphaIndexedBy(java.lang.String.class,
                                                                                                         org.drools.model.Index.ConstraintType.EQUAL,
                                                                                                         -1,
                                                                                                         _this -> _this.getEmployee()
                                                                                                                       .getAddress()
                                                                                                                       .getCountry(),
                                                                                                         "UK"),
                                                                                        D.reactOn("employee")),
                                                                 D.on(var_$d).execute((drools, $d) -> {
                                                                     {
                                                                         ($d).setDepartment("UK9876");
                                                                         drools.update($d,
                                                                                       mask_$d);
                                                                     }
                                                                 }));
        return rule;
    }

    /**
     * Rule name: US Department
     */
    public static org.drools.model.Rule rule_US_32Department() {
        final org.drools.model.Variable<org.kie.kogito.examples.hr.DepartmentModel> var_$d = D.declarationOf(org.kie.kogito.examples.hr.DepartmentModel.class,
                                                                                                             DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_DepartmentModel_Metadata_INSTANCE,
                                                                                                             "$d");
        org.drools.model.Rule rule = D.rule("org.kie.kogito.examples.hr",
                                            "US Department").build(D.pattern(var_$d).expr("BB465CF550FE8F2DD8A1048D48A444C9",
                                                                                          (_this) -> org.drools.modelcompiler.util.EvaluationUtil.areNullSafeEquals(_this.getDepartment(),
                                                                                                                                                                    "US12345"),
                                                                                          D.alphaIndexedBy(java.lang.String.class,
                                                                                                           org.drools.model.Index.ConstraintType.EQUAL,
                                                                                                           DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_DepartmentModel_Metadata_INSTANCE.getPropertyIndex("department"),
                                                                                                           _this -> _this.getDepartment(),
                                                                                                           "US12345"),
                                                                                          D.reactOn("department")),
                                                                   D.on(var_$d).execute(($d) -> {
                                                                       $d.setManager("John Doe");
                                                                   }));
        return rule;
    }

    /**
     * Rule name: UK Department
     */
    public static org.drools.model.Rule rule_UK_32Department() {
        final org.drools.model.Variable<org.kie.kogito.examples.hr.DepartmentModel> var_$d = D.declarationOf(org.kie.kogito.examples.hr.DepartmentModel.class,
                                                                                                             DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_DepartmentModel_Metadata_INSTANCE,
                                                                                                             "$d");
        org.drools.model.Rule rule = D.rule("org.kie.kogito.examples.hr",
                                            "UK Department").build(D.pattern(var_$d).expr("9168CDFA60C42E327FFD3103D48C5F20",
                                                                                          (_this) -> org.drools.modelcompiler.util.EvaluationUtil.areNullSafeEquals(_this.getDepartment(),
                                                                                                                                                                    "UK9876"),
                                                                                          D.alphaIndexedBy(java.lang.String.class,
                                                                                                           org.drools.model.Index.ConstraintType.EQUAL,
                                                                                                           DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_DepartmentModel_Metadata_INSTANCE.getPropertyIndex("department"),
                                                                                                           _this -> _this.getDepartment(),
                                                                                                           "UK9876"),
                                                                                          D.reactOn("department")),
                                                                   D.on(var_$d).execute(($d) -> {
                                                                       $d.setManager("Teresa April");
                                                                   }));
        return rule;
    }

    /**
     * Rule name: Assign Employee ID
     */
    public static org.drools.model.Rule rule_Assign_32Employee_32ID() {
        final org.drools.model.Variable<org.kie.kogito.examples.hr.IdModel> var_$id = D.declarationOf(org.kie.kogito.examples.hr.IdModel.class,
                                                                                                      DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_IdModel_Metadata_INSTANCE,
                                                                                                      "$id");
        final org.drools.model.BitMask mask_$id = org.drools.model.BitMask.getPatternMask(DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_IdModel_Metadata_INSTANCE,
                                                                                          "employeeId",
                                                                                          "employee");
        org.drools.model.Rule rule = D.rule("org.kie.kogito.examples.hr",
                                            "Assign Employee ID").build(D.pattern(var_$id),
                                                                        D.on(var_$id).execute((drools, $id) -> {
                                                                            {
                                                                                ($id).setEmployeeId(String.valueOf(($id.getEmployee()
                                                                                                                       .getFirstName() + $id.getEmployee()
                                                                                                                                            .getLastName()).hashCode()));
                                                                                drools.update($id,
                                                                                              mask_$id);
                                                                            }
                                                                        }));
        return rule;
    }

    /**
     * Rule name: Assign Employee email
     */
    public static org.drools.model.Rule rule_Assign_32Employee_32email() {
        final org.drools.model.Variable<org.kie.kogito.examples.hr.IdModel> var_$id = D.declarationOf(org.kie.kogito.examples.hr.IdModel.class,
                                                                                                      DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_IdModel_Metadata_INSTANCE,
                                                                                                      "$id");
        final org.drools.model.BitMask mask_$id = org.drools.model.BitMask.getPatternMask(DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_IdModel_Metadata_INSTANCE,
                                                                                          "employee",
                                                                                          "email");
        org.drools.model.Rule rule = D.rule("org.kie.kogito.examples.hr",
                                            "Assign Employee email").build(D.pattern(var_$id),
                                                                           D.on(var_$id).execute((drools, $id) -> {
                                                                               {
                                                                                   ($id).setEmail($id.getEmployee()
                                                                                                     .getFirstName() + "." + $id.getEmployee()
                                                                                                                                .getLastName() + "@company.com");
                                                                                   drools.update($id,
                                                                                                 mask_$id);
                                                                               }
                                                                           }));
        return rule;
    }
}
