package org.kie.kogito.examples.hr;

import java.util.*;
import org.drools.model.*;
import org.drools.modelcompiler.dsl.pattern.D;
import org.drools.model.Index.ConstraintType;
import java.time.*;
import java.time.format.*;
import java.text.*;
import org.drools.core.util.*;
import static org.kie.kogito.examples.hr.Rules209B5B6C799211C5A86114EBA882CF32.*;

public class Rules209B5B6C799211C5A86114EBA882CF32RuleMethods0 {

    /**
     * Rule name: Employee exists
     */
    public static org.drools.model.Rule rule_Employee_32exists() {
        final org.drools.model.Variable<org.kie.kogito.examples.hr.Employee> var_$emp = D.declarationOf(org.kie.kogito.examples.hr.Employee.class,
                                                                                                        DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_Employee_Metadata_INSTANCE,
                                                                                                        "$emp");
        final org.drools.model.Variable<org.kie.kogito.examples.hr.EmployeeValidationModel> var_$val = D.declarationOf(org.kie.kogito.examples.hr.EmployeeValidationModel.class,
                                                                                                                       DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_EmployeeValidationModel_Metadata_INSTANCE,
                                                                                                                       "$val");
        final org.drools.model.BitMask mask_$val = org.drools.model.BitMask.getPatternMask(DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_EmployeeValidationModel_Metadata_INSTANCE,
                                                                                           "message",
                                                                                           "employee",
                                                                                           "status");
        org.drools.model.Rule rule = D.rule("org.kie.kogito.examples.hr",
                                            "Employee exists").build(D.pattern(var_$emp).watch("personalId"),
                                                                     D.pattern(var_$val).expr("CF3518871746A846ECAEDD95FCEC2767",
                                                                                              var_$emp,
                                                                                              (_this, $emp) -> org.drools.modelcompiler.util.EvaluationUtil.areNullSafeEquals($emp.getPersonalId(),
                                                                                                                                                                              _this.getEmployee().getPersonalId()),
                                                                                              D.reactOn("employee")),
                                                                     D.on(var_$emp,
                                                                          var_$val).execute((org.drools.model.Drools drools, org.kie.kogito.examples.hr.Employee $emp, org.kie.kogito.examples.hr.EmployeeValidationModel $val) -> {
                                                                         {
                                                                             drools.delete($emp);
                                                                             ($val).setStatus("exists");
                                                                             ($val).setMessage("Employee " + $val.getEmployee()
                                                                                                                 .getFirstName() + " " + $val.getEmployee()
                                                                                                                                             .getLastName() + " is already registered");
                                                                             drools.update($val,
                                                                                           mask_$val);
                                                                         }
                                                                     }));
        return rule;
    }

    /**
     * Rule name: Employee does not exist
     */
    public static org.drools.model.Rule rule_Employee_32does_32not_32exist() {
        final org.drools.model.Variable<org.kie.kogito.examples.hr.Employee> var_$emp = D.declarationOf(org.kie.kogito.examples.hr.Employee.class,
                                                                                                        DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_Employee_Metadata_INSTANCE,
                                                                                                        "$emp");
        final org.drools.model.Variable<org.kie.kogito.examples.hr.EmployeeValidationModel> var_sCoPe1_GENERATED_$pattern_EmployeeValidationModel$1$ = D.declarationOf(org.kie.kogito.examples.hr.EmployeeValidationModel.class,
                                                                                                                                                                       DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_EmployeeValidationModel_Metadata_INSTANCE,
                                                                                                                                                                       "sCoPe1_GENERATED_$pattern_EmployeeValidationModel$1$");
        org.drools.model.Rule rule = D.rule("org.kie.kogito.examples.hr",
                                            "Employee does not exist").build(D.pattern(var_$emp).watch("personalId"),
                                                                             D.not(D.pattern(var_sCoPe1_GENERATED_$pattern_EmployeeValidationModel$1$).expr("CF3518871746A846ECAEDD95FCEC2767",
                                                                                                                                                            var_$emp,
                                                                                                                                                            (_this, $emp) -> org.drools.modelcompiler.util.EvaluationUtil.areNullSafeEquals($emp.getPersonalId(),
                                                                                                                                                                                                                                            _this.getEmployee().getPersonalId()),
                                                                                                                                                            D.reactOn("employee"))),
                                                                             D.on(var_$emp).execute((org.drools.model.Drools drools, org.kie.kogito.examples.hr.Employee $emp) -> {
                                                                                 EmployeeValidationModel val = new EmployeeValidationModel();
                                                                                 val.setEmployee($emp);
                                                                                 val.setStatus("new");
                                                                                 val.setMessage("Employee " + $emp.getFirstName() + " " + $emp.getLastName() + " is not yet registered");
                                                                                 drools.delete($emp);
                                                                                 drools.insert(val);
                                                                             }));
        return rule;
    }

    /**
     * Rule name: US Employee
     */
    public static org.drools.model.Rule rule_US_32Employee() {
        final org.drools.model.Variable<org.kie.kogito.examples.hr.DepartmentModel> var_$d = D.declarationOf(org.kie.kogito.examples.hr.DepartmentModel.class,
                                                                                                             DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_DepartmentModel_Metadata_INSTANCE,
                                                                                                             "$d");
        final org.drools.model.BitMask mask_$d = org.drools.model.BitMask.getPatternMask(DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_DepartmentModel_Metadata_INSTANCE,
                                                                                         "department");
        org.drools.model.Rule rule = D.rule("org.kie.kogito.examples.hr",
                                            "US Employee").build(D.pattern(var_$d).expr("D05E92EAF7E0CA366D521438A3495826",
                                                                                        org.kie.kogito.examples.hr.LambdaPredicate1502B2168A4B1D4AD9F4D5CC6ADEB07D.INSTANCE,
                                                                                        D.alphaIndexedBy(java.lang.String.class,
                                                                                                         org.drools.model.Index.ConstraintType.EQUAL,
                                                                                                         -1,
                                                                                                         org.kie.kogito.examples.hr.LambdaExtractor5284AFE7E535167AA53D14BBFBA4F0B2.INSTANCE,
                                                                                                         "US"),
                                                                                        D.reactOn("employee")),
                                                                 D.on(var_$d).execute((org.drools.model.Drools drools, org.kie.kogito.examples.hr.DepartmentModel $d) -> {
                                                                     {
                                                                         ($d).setDepartment("US12345");
                                                                         drools.update($d,
                                                                                       mask_$d);
                                                                     }
                                                                 }));
        return rule;
    }

    /**
     * Rule name: UK Employee
     */
    public static org.drools.model.Rule rule_UK_32Employee() {
        final org.drools.model.Variable<org.kie.kogito.examples.hr.DepartmentModel> var_$d = D.declarationOf(org.kie.kogito.examples.hr.DepartmentModel.class,
                                                                                                             DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_DepartmentModel_Metadata_INSTANCE,
                                                                                                             "$d");
        final org.drools.model.BitMask mask_$d = org.drools.model.BitMask.getPatternMask(DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_DepartmentModel_Metadata_INSTANCE,
                                                                                         "department");
        org.drools.model.Rule rule = D.rule("org.kie.kogito.examples.hr",
                                            "UK Employee").build(D.pattern(var_$d).expr("F02DD8AC66392E172ACC15450D74A344",
                                                                                        org.kie.kogito.examples.hr.LambdaPredicate0FABAC46EEA273DD8ED7AAC932A009CC.INSTANCE,
                                                                                        D.alphaIndexedBy(java.lang.String.class,
                                                                                                         org.drools.model.Index.ConstraintType.EQUAL,
                                                                                                         -1,
                                                                                                         org.kie.kogito.examples.hr.LambdaExtractor5284AFE7E535167AA53D14BBFBA4F0B2.INSTANCE,
                                                                                                         "UK"),
                                                                                        D.reactOn("employee")),
                                                                 D.on(var_$d).execute((org.drools.model.Drools drools, org.kie.kogito.examples.hr.DepartmentModel $d) -> {
                                                                     {
                                                                         ($d).setDepartment("UK9876");
                                                                         drools.update($d,
                                                                                       mask_$d);
                                                                     }
                                                                 }));
        return rule;
    }

    /**
     * Rule name: US Department
     */
    public static org.drools.model.Rule rule_US_32Department() {
        final org.drools.model.Variable<org.kie.kogito.examples.hr.DepartmentModel> var_$d = D.declarationOf(org.kie.kogito.examples.hr.DepartmentModel.class,
                                                                                                             DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_DepartmentModel_Metadata_INSTANCE,
                                                                                                             "$d");
        org.drools.model.Rule rule = D.rule("org.kie.kogito.examples.hr",
                                            "US Department").build(D.pattern(var_$d).expr("BB465CF550FE8F2DD8A1048D48A444C9",
                                                                                          org.kie.kogito.examples.hr.LambdaPredicateC1CAED26F40C4C631A70F1CBBCE3B4E1.INSTANCE,
                                                                                          D.alphaIndexedBy(java.lang.String.class,
                                                                                                           org.drools.model.Index.ConstraintType.EQUAL,
                                                                                                           DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_DepartmentModel_Metadata_INSTANCE.getPropertyIndex("department"),
                                                                                                           org.kie.kogito.examples.hr.LambdaExtractorE29847B352B046D230AE7E07C0C3EAB3.INSTANCE,
                                                                                                           "US12345"),
                                                                                          D.reactOn("department")),
                                                                   D.on(var_$d).execute(org.kie.kogito.examples.hr.LambdaConsequence68FED1670A3744C9CBAC85800BBED016.INSTANCE));
        return rule;
    }

    /**
     * Rule name: UK Department
     */
    public static org.drools.model.Rule rule_UK_32Department() {
        final org.drools.model.Variable<org.kie.kogito.examples.hr.DepartmentModel> var_$d = D.declarationOf(org.kie.kogito.examples.hr.DepartmentModel.class,
                                                                                                             DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_DepartmentModel_Metadata_INSTANCE,
                                                                                                             "$d");
        org.drools.model.Rule rule = D.rule("org.kie.kogito.examples.hr",
                                            "UK Department").build(D.pattern(var_$d).expr("9168CDFA60C42E327FFD3103D48C5F20",
                                                                                          org.kie.kogito.examples.hr.LambdaPredicate909452B8340FC003AE46293849C57418.INSTANCE,
                                                                                          D.alphaIndexedBy(java.lang.String.class,
                                                                                                           org.drools.model.Index.ConstraintType.EQUAL,
                                                                                                           DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_DepartmentModel_Metadata_INSTANCE.getPropertyIndex("department"),
                                                                                                           org.kie.kogito.examples.hr.LambdaExtractorE29847B352B046D230AE7E07C0C3EAB3.INSTANCE,
                                                                                                           "UK9876"),
                                                                                          D.reactOn("department")),
                                                                   D.on(var_$d).execute(org.kie.kogito.examples.hr.LambdaConsequence5FB0B70FE56F0143A39BC3A8D5052C8D.INSTANCE));
        return rule;
    }

    /**
     * Rule name: Assign Employee ID
     */
    public static org.drools.model.Rule rule_Assign_32Employee_32ID() {
        final org.drools.model.Variable<org.kie.kogito.examples.hr.IdModel> var_$id = D.declarationOf(org.kie.kogito.examples.hr.IdModel.class,
                                                                                                      DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_IdModel_Metadata_INSTANCE,
                                                                                                      "$id");
        final org.drools.model.BitMask mask_$id = org.drools.model.BitMask.getPatternMask(DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_IdModel_Metadata_INSTANCE,
                                                                                          "employeeId",
                                                                                          "employee");
        org.drools.model.Rule rule = D.rule("org.kie.kogito.examples.hr",
                                            "Assign Employee ID").build(D.pattern(var_$id),
                                                                        D.on(var_$id).execute((org.drools.model.Drools drools, org.kie.kogito.examples.hr.IdModel $id) -> {
                                                                            {
                                                                                ($id).setEmployeeId(String.valueOf(($id.getEmployee()
                                                                                                                       .getFirstName() + $id.getEmployee()
                                                                                                                                            .getLastName()).hashCode()));
                                                                                drools.update($id,
                                                                                              mask_$id);
                                                                            }
                                                                        }));
        return rule;
    }

    /**
     * Rule name: Assign Employee email
     */
    public static org.drools.model.Rule rule_Assign_32Employee_32email() {
        final org.drools.model.Variable<org.kie.kogito.examples.hr.IdModel> var_$id = D.declarationOf(org.kie.kogito.examples.hr.IdModel.class,
                                                                                                      DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_IdModel_Metadata_INSTANCE,
                                                                                                      "$id");
        final org.drools.model.BitMask mask_$id = org.drools.model.BitMask.getPatternMask(DomainClassesMetadata209B5B6C799211C5A86114EBA882CF32.org_kie_kogito_examples_hr_IdModel_Metadata_INSTANCE,
                                                                                          "employee",
                                                                                          "email");
        org.drools.model.Rule rule = D.rule("org.kie.kogito.examples.hr",
                                            "Assign Employee email").build(D.pattern(var_$id),
                                                                           D.on(var_$id).execute((org.drools.model.Drools drools, org.kie.kogito.examples.hr.IdModel $id) -> {
                                                                               {
                                                                                   ($id).setEmail($id.getEmployee()
                                                                                                     .getFirstName() + "." + $id.getEmployee()
                                                                                                                                .getLastName() + "@company.com");
                                                                                   drools.update($id,
                                                                                                 mask_$id);
                                                                               }
                                                                           }));
        return rule;
    }
}
