package org.kie.kogito.examples;

import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.ruleflow.core.RuleFlowProcessFactory;
import org.drools.core.util.KieFunctions;

@org.springframework.stereotype.Component("flights")
public class FlightsProcess extends org.kie.kogito.process.impl.AbstractProcess<org.kie.kogito.examples.FlightsModel> {

    @org.springframework.beans.factory.annotation.Autowired(required = false)
    java.util.List<org.kie.api.runtime.process.WorkItemHandler> handlers;

    org.kie.kogito.examples.Application app;

    public FlightsProcess() {
    }

    @org.springframework.beans.factory.annotation.Autowired()
    public FlightsProcess(org.kie.kogito.examples.Application app) {
        super(app.config().process());
        this.app = app;
    }

    public org.kie.kogito.examples.FlightsProcessInstance createInstance(org.kie.kogito.examples.FlightsModel value) {
        return new org.kie.kogito.examples.FlightsProcessInstance(this, value, this.createLegacyProcessRuntime());
    }

    public org.kie.kogito.examples.FlightsProcessInstance createInstance(java.lang.String businessKey, org.kie.kogito.examples.FlightsModel value) {
        return new org.kie.kogito.examples.FlightsProcessInstance(this, value, businessKey, this.createLegacyProcessRuntime());
    }

    public org.kie.kogito.examples.FlightsModel createModel() {
        return new org.kie.kogito.examples.FlightsModel();
    }

    public org.kie.kogito.examples.FlightsProcessInstance createInstance(org.kie.kogito.Model value) {
        return this.createInstance((org.kie.kogito.examples.FlightsModel) value);
    }

    public org.kie.kogito.examples.FlightsProcessInstance createInstance(java.lang.String businessKey, org.kie.kogito.Model value) {
        return this.createInstance(businessKey, (org.kie.kogito.examples.FlightsModel) value);
    }

    public FlightsProcess configure() {
        super.configure();
        handlers.forEach(h -> {
            services.getWorkItemManager().registerWorkItemHandler(h.getName(), h);
        });
        handlers.forEach(h -> {
            services.getWorkItemManager().registerWorkItemHandler(h.getName(), h);
        });
        handlers.forEach(h -> {
            services.getWorkItemManager().registerWorkItemHandler(h.getName(), h);
        });
        return this;
    }

    protected void registerListeners() {
    }

    public org.kie.api.definition.process.Process legacyProcess() {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess("flights");
        factory.variable("flight", new ObjectDataType("org.kie.kogito.examples.domain.Flight"), "customTags", null);
        factory.variable("params", new ObjectDataType("org.kie.kogito.examples.domain.FlightDTO"), "customTags", null);
        factory.variable("isPassengerListFinalized", new ObjectDataType("java.lang.Boolean"), "customTags", null);
        factory.variable("processId", new ObjectDataType("java.lang.String"), "customTags", null);
        factory.variable("isSolving", new ObjectDataType("java.lang.Boolean"), "customTags", null);
        factory.variable("isPassengerApproved", new ObjectDataType("java.lang.Boolean"), "customTags", null);
        factory.variable("passengerRequest", new ObjectDataType("org.kie.kogito.examples.domain.PassengerDTO"), "customTags", null);
        factory.name("Schedule Flight");
        factory.packageName("org.kie.kogito.examples");
        factory.dynamic(false);
        factory.version("1.0");
        factory.visibility("Public");
        factory.metaData("TargetNamespace", "http://www.omg.org/bpmn20");
        org.jbpm.ruleflow.core.factory.ActionNodeFactory actionNode1 = factory.actionNode(1);
        actionNode1.name("Update Is Solving");
        actionNode1.action(kcontext -> {
            org.kie.kogito.examples.domain.Flight flight = (org.kie.kogito.examples.domain.Flight) kcontext.getVariable("flight");
            org.kie.kogito.examples.domain.FlightDTO params = (org.kie.kogito.examples.domain.FlightDTO) kcontext.getVariable("params");
            java.lang.Boolean isPassengerListFinalized = (java.lang.Boolean) kcontext.getVariable("isPassengerListFinalized");
            java.lang.String processId = (java.lang.String) kcontext.getVariable("processId");
            java.lang.Boolean isSolving = (java.lang.Boolean) kcontext.getVariable("isSolving");
            kcontext.setVariable("isSolving", false);;
        });
        actionNode1.metaData("UniqueId", "_60253406-278F-45E1-85BD-9FEBB74751E7");
        actionNode1.metaData("elementname", "Update Is Solving");
        actionNode1.metaData("NodeType", "ScriptTask");
        actionNode1.metaData("x", 1036);
        actionNode1.metaData("width", 154);
        actionNode1.metaData("y", 678);
        actionNode1.metaData("height", 102);
        actionNode1.done();
        org.jbpm.ruleflow.core.factory.EventNodeFactory eventNode2 = factory.eventNode(2);
        eventNode2.name("Solver Terminated");
        eventNode2.eventType("solvingTerminated");
        eventNode2.variableName("flight");
        eventNode2.metaData("UniqueId", "_A6004C5E-5187-4DDE-A3C0-E7CA351B2E96");
        eventNode2.metaData("elementname", "Solver Terminated");
        eventNode2.metaData("EventType", "signal");
        eventNode2.metaData("x", 916);
        eventNode2.metaData("width", 56);
        eventNode2.metaData("y", 701);
        eventNode2.metaData("height", 56);
        eventNode2.done();
        org.jbpm.ruleflow.core.factory.ActionNodeFactory actionNode3 = factory.actionNode(3);
        actionNode3.name("Init Variables");
        actionNode3.action(kcontext -> {
            org.kie.kogito.examples.domain.Flight flight = (org.kie.kogito.examples.domain.Flight) kcontext.getVariable("flight");
            org.kie.kogito.examples.domain.FlightDTO params = (org.kie.kogito.examples.domain.FlightDTO) kcontext.getVariable("params");
            java.lang.Boolean isPassengerListFinalized = (java.lang.Boolean) kcontext.getVariable("isPassengerListFinalized");
            java.lang.String processId = (java.lang.String) kcontext.getVariable("processId");
            java.lang.Boolean isSolving = (java.lang.Boolean) kcontext.getVariable("isSolving");
            kcontext.setVariable("isPassengerListFinalized", false);
kcontext.setVariable("isSolving", true);
kcontext.setVariable("processId", kcontext.getProcessInstance().getId());;
        });
        actionNode3.metaData("UniqueId", "_900631B7-3F2A-4B12-859E-BC49336F1845");
        actionNode3.metaData("elementname", "Init Variables");
        actionNode3.metaData("NodeType", "ScriptTask");
        actionNode3.metaData("x", 251);
        actionNode3.metaData("width", 154);
        actionNode3.metaData("y", 67);
        actionNode3.metaData("height", 102);
        actionNode3.done();
        org.jbpm.ruleflow.core.factory.WorkItemNodeFactory workItemNode4 = factory.workItemNode(4);
        workItemNode4.name("Create Seat Assignments");
        workItemNode4.workName("org.kie.kogito.examples.service.FlightSeatingSolveService.assignSeats");
        workItemNode4.workParameter("Interface", "org.kie.kogito.examples.service.FlightSeatingSolveService");
        workItemNode4.workParameter("Operation", "assignSeats");
        workItemNode4.workParameter("interfaceImplementationRef", "org.kie.kogito.examples.service.FlightSeatingSolveService");
        workItemNode4.workParameter("operationImplementationRef", "assignSeats");
        workItemNode4.workParameter("implementation", "Java");
        workItemNode4.inMapping("problem", "flight");
        workItemNode4.inMapping("problemId", "processId");
        workItemNode4.done();
        workItemNode4.metaData("UniqueId", "_33D305B7-7E3C-4704-860C-F3B6C4262B37");
        workItemNode4.metaData("Implementation", "Java");
        workItemNode4.metaData("elementname", "Create Seat Assignments");
        workItemNode4.metaData("Type", "Service Task");
        workItemNode4.metaData("OperationRef", "_33D305B7-7E3C-4704-860C-F3B6C4262B37_ServiceOperation");
        workItemNode4.metaData("x", 697);
        workItemNode4.metaData("width", 153);
        workItemNode4.metaData("y", 678);
        workItemNode4.metaData("height", 101);
        org.jbpm.ruleflow.core.factory.EndNodeFactory endNode5 = factory.endNode(5);
        endNode5.name("End");
        endNode5.terminate(true);
        endNode5.metaData("UniqueId", "_C0E64248-F51D-4AA7-8E6F-22011EF77B8A");
        endNode5.metaData("x", 1460);
        endNode5.metaData("width", 56);
        endNode5.metaData("y", 701);
        endNode5.metaData("height", 56);
        endNode5.done();
        org.jbpm.ruleflow.core.factory.HumanTaskNodeFactory humanTaskNode6 = factory.humanTaskNode(6);
        humanTaskNode6.name("Finalize Seat Assignments");
        humanTaskNode6.workParameter("TaskName", "finalizeSeatAssignment");
        humanTaskNode6.workParameter("Skippable", "false");
        humanTaskNode6.workParameter("NodeName", "Finalize Seat Assignments");
        humanTaskNode6.done();
        humanTaskNode6.metaData("UniqueId", "_F9063D79-F12D-4F18-9EE2-7034AE7C4776");
        humanTaskNode6.metaData("elementname", "Finalize Seat Assignments");
        humanTaskNode6.metaData("x", 1248);
        humanTaskNode6.metaData("width", 154);
        humanTaskNode6.metaData("y", 678);
        humanTaskNode6.metaData("height", 102);
        org.jbpm.ruleflow.core.factory.HumanTaskNodeFactory humanTaskNode7 = factory.humanTaskNode(7);
        humanTaskNode7.name("Finalize Passenger List");
        humanTaskNode7.workParameter("TaskName", "finalizePassengerList");
        humanTaskNode7.workParameter("Skippable", "false");
        humanTaskNode7.workParameter("NodeName", "Finalize Passenger List");
        humanTaskNode7.outMapping("isPassengerListFinalized", "isPassengerListFinalized");
        humanTaskNode7.done();
        humanTaskNode7.metaData("UniqueId", "_5289B275-031F-437C-9538-CF0D3D4E83B9");
        humanTaskNode7.metaData("elementname", "Finalize Passenger List");
        humanTaskNode7.metaData("x", 472);
        humanTaskNode7.metaData("width", 154);
        humanTaskNode7.metaData("y", 678);
        humanTaskNode7.metaData("height", 102);
        org.jbpm.ruleflow.core.factory.WorkItemNodeFactory workItemNode8 = factory.workItemNode(8);
        workItemNode8.name("Create a new flight");
        workItemNode8.workName("org.kie.kogito.examples.service.FlightService.createFlight");
        workItemNode8.workParameter("Interface", "org.kie.kogito.examples.service.FlightService");
        workItemNode8.workParameter("Operation", "createFlight");
        workItemNode8.workParameter("interfaceImplementationRef", "org.kie.kogito.examples.service.FlightService");
        workItemNode8.workParameter("operationImplementationRef", "createFlight");
        workItemNode8.workParameter("implementation", "Java");
        workItemNode8.inMapping("flightParams", "params");
        workItemNode8.outMapping("flight", "flight");
        workItemNode8.done();
        workItemNode8.metaData("UniqueId", "_3DA12126-C2FD-49CE-9119-615965FAC79D");
        workItemNode8.metaData("Implementation", "Java");
        workItemNode8.metaData("elementname", "Create a new flight");
        workItemNode8.metaData("Type", "Service Task");
        workItemNode8.metaData("OperationRef", "_3DA12126-C2FD-49CE-9119-615965FAC79D_ServiceOperation");
        workItemNode8.metaData("x", 472);
        workItemNode8.metaData("width", 154);
        workItemNode8.metaData("y", 67);
        workItemNode8.metaData("height", 102);
        org.jbpm.ruleflow.core.factory.StartNodeFactory startNode9 = factory.startNode(9);
        startNode9.name("Process Start");
        startNode9.interrupting(false);
        startNode9.metaData("UniqueId", "_02BFCEB6-C148-4F2B-9CC9-E5BA5D7AFEDC");
        startNode9.metaData("elementname", "Process Start");
        startNode9.metaData("x", 153);
        startNode9.metaData("width", 56);
        startNode9.metaData("y", 90);
        startNode9.metaData("height", 56);
        startNode9.done();
        org.jbpm.ruleflow.core.factory.EventSubProcessNodeFactory compositeContextNode10 = factory.eventSubProcessNode(10);
        compositeContextNode10.metaData("UniqueId", "_17238CD5-CB35-476E-A44C-B3A8E6F69096");
        compositeContextNode10.metaData("elementname", "New Best Solution");
        compositeContextNode10.metaData("x", 820);
        compositeContextNode10.metaData("width", 248);
        compositeContextNode10.metaData("y", 821);
        compositeContextNode10.metaData("height", 194);
        org.jbpm.ruleflow.core.factory.EndNodeFactory endNode11 = compositeContextNode10.endNode(11);
        endNode11.name("End");
        endNode11.terminate(false);
        endNode11.metaData("UniqueId", "_A30E28B4-D9E9-4FFD-B4F0-FD9B2A2785FD");
        endNode11.metaData("x", 164);
        endNode11.metaData("width", 56);
        endNode11.metaData("y", 75);
        endNode11.metaData("height", 56);
        endNode11.done();
        org.jbpm.ruleflow.core.factory.StartNodeFactory startNode12 = compositeContextNode10.startNode(12);
        startNode12.name("New Best Solution");
        startNode12.interrupting(false);
        startNode12.metaData("TriggerMapping", "flight");
        startNode12.metaData("UniqueId", "_61AEF811-220F-4DB6-B0A1-818711C48323");
        startNode12.metaData("elementname", "New Best Solution");
        startNode12.metaData("TriggerType", "Signal");
        startNode12.metaData("x", 38);
        startNode12.metaData("width", 56);
        startNode12.metaData("y", 75);
        startNode12.metaData("TriggerRef", "newSolution");
        startNode12.metaData("MessageType", "newSolution");
        startNode12.metaData("height", 56);
        startNode12.done();
        startNode12.trigger("newSolution", "flight");
        startNode12.trigger("newSolution", "flight");
        compositeContextNode10.connection(12, 11, "_FC08A6A9-83FD-4950-B063-830CCB08F55B");
        compositeContextNode10.done();
        org.jbpm.ruleflow.core.factory.EventSubProcessNodeFactory compositeContextNode13 = factory.eventSubProcessNode(13);
        compositeContextNode13.metaData("UniqueId", "_C9CB4707-AB7F-4B46-BFA2-4F8BF25AA037");
        compositeContextNode13.metaData("elementname", "Passenger Boarding Request");
        compositeContextNode13.metaData("x", 618);
        compositeContextNode13.metaData("width", 989);
        compositeContextNode13.metaData("y", 203);
        compositeContextNode13.metaData("customAsync", "true");
        compositeContextNode13.metaData("height", 401);
        compositeContextNode13.variable("isPassengerApproved", new ObjectDataType("java.lang.Boolean"), "customTags", null);
        compositeContextNode13.variable("passengerRequest", new ObjectDataType("org.kie.kogito.examples.domain.PassengerDTO"), "customTags", null);
        org.jbpm.ruleflow.core.factory.WorkItemNodeFactory workItemNode16 = compositeContextNode13.workItemNode(16);
        workItemNode16.name("Add Passenger To Flight");
        workItemNode16.workName("org.kie.kogito.examples.service.FlightService.addPassengerToFlight");
        workItemNode16.workParameter("Interface", "org.kie.kogito.examples.service.FlightService");
        workItemNode16.workParameter("Operation", "addPassengerToFlight");
        workItemNode16.workParameter("interfaceImplementationRef", "org.kie.kogito.examples.service.FlightService");
        workItemNode16.workParameter("operationImplementationRef", "addPassengerToFlight");
        workItemNode16.workParameter("implementation", "Java");
        workItemNode16.inMapping("flight", "flight");
        workItemNode16.inMapping("passenger", "passengerRequest");
        workItemNode16.outMapping("flight", "flight");
        workItemNode16.done();
        workItemNode16.metaData("UniqueId", "_5509C065-1D42-426E-8FF9-64D1E2E7B2EF");
        workItemNode16.metaData("Implementation", "Java");
        workItemNode16.metaData("elementname", "Add Passenger To Flight");
        workItemNode16.metaData("Type", "Service Task");
        workItemNode16.metaData("OperationRef", "_5509C065-1D42-426E-8FF9-64D1E2E7B2EF_ServiceOperation");
        workItemNode16.metaData("x", 665);
        workItemNode16.metaData("width", 154);
        workItemNode16.metaData("y", 93);
        workItemNode16.metaData("height", 102);
        org.jbpm.ruleflow.core.factory.SplitFactory splitNode17 = compositeContextNode13.splitNode(17);
        splitNode17.name("Is Passenger Approved?");
        splitNode17.type(2);
        splitNode17.metaData("UniqueId", "_88B43256-BDA2-4AA8-B5A3-F43D9B799234");
        splitNode17.metaData("elementname", "Is Passenger Approved?");
        splitNode17.metaData("x", 517);
        splitNode17.metaData("width", 56);
        splitNode17.metaData("y", 116);
        splitNode17.metaData("height", 56);
        splitNode17.constraint(14, "_94AD6769-D320-49C0-9CC1-92132A075462", "DROOLS_DEFAULT", "java", kcontext -> {
            java.lang.Boolean isPassengerApproved = (java.lang.Boolean) kcontext.getVariable("isPassengerApproved");
            org.kie.kogito.examples.domain.PassengerDTO passengerRequest = (org.kie.kogito.examples.domain.PassengerDTO) kcontext.getVariable("passengerRequest");
            {
                return !isPassengerApproved;
            }
        }, 0);
        splitNode17.constraint(16, "_C6BEB443-A465-4A89-B0CE-ACB76BEE7D03", "DROOLS_DEFAULT", "java", kcontext -> {
            java.lang.Boolean isPassengerApproved = (java.lang.Boolean) kcontext.getVariable("isPassengerApproved");
            org.kie.kogito.examples.domain.PassengerDTO passengerRequest = (org.kie.kogito.examples.domain.PassengerDTO) kcontext.getVariable("passengerRequest");
            {
                return isPassengerApproved;
            }
        }, 0);
        splitNode17.done();
        org.jbpm.ruleflow.core.factory.HumanTaskNodeFactory humanTaskNode18 = compositeContextNode13.humanTaskNode(18);
        humanTaskNode18.name("Approve/Deny Passenger");
        humanTaskNode18.workParameter("TaskName", "approveDenyPassenger");
        humanTaskNode18.workParameter("Skippable", "false");
        humanTaskNode18.workParameter("NodeName", "Approve/Deny Passenger");
        humanTaskNode18.inMapping("passenger", "passengerRequest");
        humanTaskNode18.outMapping("isPassengerApproved", "isPassengerApproved");
        humanTaskNode18.done();
        humanTaskNode18.metaData("UniqueId", "_1120E34E-319E-49DF-AF68-7BB569F92ADC");
        humanTaskNode18.metaData("elementname", "Approve/Deny Passenger");
        humanTaskNode18.metaData("x", 272);
        humanTaskNode18.metaData("width", 154);
        humanTaskNode18.metaData("y", 93);
        humanTaskNode18.metaData("height", 102);
        org.jbpm.ruleflow.core.factory.StartNodeFactory startNode19 = compositeContextNode13.startNode(19);
        startNode19.name("New Passenger Boarding Request");
        startNode19.interrupting(false);
        startNode19.metaData("TriggerMapping", "passengerRequest");
        startNode19.metaData("UniqueId", "_3F96473B-23BA-4A72-83D3-3EA4B33665D1");
        startNode19.metaData("elementname", "New Passenger Boarding Request");
        startNode19.metaData("TriggerType", "Signal");
        startNode19.metaData("x", 98);
        startNode19.metaData("width", 56);
        startNode19.metaData("y", 117);
        startNode19.metaData("TriggerRef", "newPassengerRequest");
        startNode19.metaData("MessageType", "newPassengerRequest");
        startNode19.metaData("height", 56);
        startNode19.done();
        startNode19.trigger("newPassengerRequest", "passengerRequest");
        startNode19.trigger("newPassengerRequest", "passengerRequest");
        org.jbpm.ruleflow.core.factory.EndNodeFactory endNode14 = compositeContextNode13.endNode(14);
        endNode14.name("End");
        endNode14.terminate(false);
        endNode14.metaData("UniqueId", "_1D32B117-1B5F-4F39-B2FC-9E682CA0B465");
        endNode14.metaData("x", 517);
        endNode14.metaData("width", 56);
        endNode14.metaData("y", 300);
        endNode14.metaData("height", 56);
        endNode14.done();
        org.jbpm.ruleflow.core.factory.EndNodeFactory endNode15 = compositeContextNode13.endNode(15);
        endNode15.name("End");
        endNode15.terminate(false);
        endNode15.metaData("UniqueId", "_1CBDC9E4-A8ED-4927-A7A9-2199194E569B");
        endNode15.metaData("x", 911);
        endNode15.metaData("width", 56);
        endNode15.metaData("y", 116);
        endNode15.metaData("height", 56);
        endNode15.done();
        compositeContextNode13.connection(17, 16, "_C6BEB443-A465-4A89-B0CE-ACB76BEE7D03");
        compositeContextNode13.connection(18, 17, "_3FD370AA-36A7-4074-8977-5F58E0E88F04");
        compositeContextNode13.connection(19, 18, "_8AE45BEB-7A37-4A21-B22A-3DA124D3368E");
        compositeContextNode13.connection(17, 14, "_94AD6769-D320-49C0-9CC1-92132A075462");
        compositeContextNode13.connection(16, 15, "_A95FF555-9C22-42E4-A25F-7D4724BD2AEF");
        compositeContextNode13.done();
        factory.connection(2, 1, "_84ABBA79-4757-4215-8959-2747FAC73471");
        factory.connection(4, 2, "_A59B010C-5D2C-45DF-9219-A46D06EEE82D");
        factory.connection(9, 3, "_F33764FA-886E-4033-AD8B-7D7F0FC5EA5D");
        factory.connection(7, 4, "_EF6673DD-1D02-4E37-833A-810CB29DC113");
        factory.connection(6, 5, "_29D92CB9-DE14-4571-9399-FD1BAD9595D6");
        factory.connection(1, 6, "_7FCA2AF9-B5EB-4C08-ABF5-E10D9917E88E");
        factory.connection(8, 7, "_1C8C09DA-FFCF-4ACA-A3FD-D63E14B32C41");
        factory.connection(3, 8, "_4F515548-C937-4BA7-84D5-21776CFD70D5");
        factory.validate();
        return factory.getProcess();
    }

    @javax.annotation.PostConstruct()
    public void init() {
        this.activate();
    }
}
