package org.kie.kogito.examples;

import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.ruleflow.core.RuleFlowProcessFactory;
import org.drools.core.util.KieFunctions;

public class OrderItemsProcess extends org.kie.kogito.process.impl.AbstractProcess<org.kie.kogito.examples.OrderItemsModel> {

    org.kie.kogito.examples.Application app;

    public OrderItemsProcess() {
        this(new org.kie.kogito.examples.Application());
    }

    public OrderItemsProcess(org.kie.kogito.examples.Application app) {
        super(app.config().process());
        this.app = app;
    }

    public org.kie.kogito.examples.OrderItemsProcessInstance createInstance(org.kie.kogito.examples.OrderItemsModel value) {
        return new org.kie.kogito.examples.OrderItemsProcessInstance(this, value, this.createLegacyProcessRuntime());
    }

    public org.kie.kogito.examples.OrderItemsModel createModel() {
        return new org.kie.kogito.examples.OrderItemsModel();
    }

    public org.kie.kogito.examples.OrderItemsProcessInstance createInstance(org.kie.kogito.Model value) {
        return this.createInstance((org.kie.kogito.examples.OrderItemsModel) value);
    }

    public OrderItemsProcess configure() {
        services.getWorkItemManager().registerWorkItemHandler("org.kie.kogito.examples.CalculationService.calculateTotal", new org.kie.kogito.handlers.CalculationService_calculateTotalHandler());
        return this;
    }

    protected org.kie.api.definition.process.Process legacyProcess() {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess("demo.orderItems");
        factory.variable("order", new ObjectDataType("org.kie.kogito.examples.demo.Order"));
        factory.variable("item", new ObjectDataType("java.lang.String"));
        factory.name("orderItems");
        factory.packageName("org.kie.kogito.examples");
        factory.dynamic(false);
        factory.version("1.0");
        factory.visibility("Private");
        factory.metaData("TargetNamespace", "http://www.omg.org/bpmn20");
        factory.imports("org.kie.kogito.examples.demo.Order");
        org.jbpm.ruleflow.core.factory.StartNodeFactory startNode1 = factory.startNode(1);
        startNode1.name("Start");
        startNode1.done();
        org.jbpm.ruleflow.core.factory.EndNodeFactory endNode2 = factory.endNode(2);
        endNode2.name("End");
        endNode2.terminate(false);
        endNode2.done();
        org.jbpm.ruleflow.core.factory.WorkItemNodeFactory workItemNode3 = factory.workItemNode(3);
        workItemNode3.name("Calculate total");
        workItemNode3.workName("org.kie.kogito.examples.CalculationService.calculateTotal");
        workItemNode3.workParameter("ParameterType", "org.kie.kogito.examples.demo.Order");
        workItemNode3.workParameter("interfaceImplementationRef", "org.kie.kogito.examples.CalculationService");
        workItemNode3.workParameter("implementation", "java");
        workItemNode3.workParameter("Operation", "calculateTotal");
        workItemNode3.workParameter("Interface", "org.kie.kogito.examples.CalculationService");
        workItemNode3.inMapping("Parameter", "order");
        workItemNode3.outMapping("Result", "order");
        workItemNode3.done();
        org.jbpm.ruleflow.core.factory.HumanTaskNodeFactory humanTaskNode4 = factory.humanTaskNode(4);
        humanTaskNode4.name("Verify order");
        humanTaskNode4.workParameter("Locale", "en-UK");
        humanTaskNode4.workParameter("TaskName", "Verify order");
        humanTaskNode4.workParameter("NodeName", "Verify order");
        humanTaskNode4.workParameter("Priority", "1");
        humanTaskNode4.workParameter("Skippable", "true");
        humanTaskNode4.workParameter("ActorId", "john");
        humanTaskNode4.inMapping("input1", "order");
        humanTaskNode4.done();
        factory.connection(4, 2, "SequenceFlow_4");
        factory.connection(1, 3, "SequenceFlow_1");
        factory.connection(3, 4, "SequenceFlow_3");
        factory.validate();
        return factory.getProcess();
    }
}
