package org.kie.kogito.examples;

import org.kie.kogito.Config;
import org.kie.kogito.process.Processes;
import org.kie.kogito.uow.UnitOfWorkManager;

@org.springframework.stereotype.Component()
public class Application implements org.kie.kogito.Application {

    private static UnitOfWorkManager unitOfWorkManager = new org.kie.kogito.services.uow.DefaultUnitOfWorkManager(new org.kie.kogito.services.uow.CollectingUnitOfWorkFactory());

    public Config config() {
        return config;
    }

    public UnitOfWorkManager unitOfWorkManager() {
        return unitOfWorkManager;
    }

    public static org.kie.kogito.Config config = new org.kie.kogito.StaticConfig(new org.kie.kogito.process.impl.StaticProcessConfig(new org.kie.kogito.process.impl.DefaultWorkItemHandlerConfig(), new org.kie.kogito.process.impl.DefaultProcessEventListenerConfig(), unitOfWorkManager), new org.drools.core.config.StaticRuleConfig(new org.drools.core.config.DefaultRuleEventListenerConfig()));

    RuleUnits ruleUnits = new RuleUnits();

    public RuleUnits ruleUnits() {
        return ruleUnits;
    }

    public class RuleUnits implements org.kie.kogito.rules.RuleUnits {

        org.kie.kogito.rules.KieRuntimeBuilder ruleRuntimeBuilder = new org.drools.project.model.ProjectRuntime();

        public org.kie.kogito.rules.KieRuntimeBuilder ruleRuntimeBuilder() {
            return this.ruleRuntimeBuilder;
        }
    }

    Processes processes = new Processes();

    public Processes processes() {
        return processes;
    }

    public class Processes implements org.kie.kogito.process.Processes {

        public org.kie.kogito.process.Process<? extends org.kie.kogito.Model> processById(String processId) {
            if ("persons".equals(processId))
                return createPersonsProcess();
            if ("demo.orderItems".equals(processId))
                return createOrderItemsProcess();
            if ("demo.orders".equals(processId))
                return createOrdersProcess();
            return null;
        }

        public java.util.Collection<String> processIds() {
            return java.util.Arrays.asList("persons", "demo.orderItems", "demo.orders");
        }

        public org.kie.kogito.examples.demo.PersonsProcess createPersonsProcess() {
            return new org.kie.kogito.examples.demo.PersonsProcess(Application.this).configure();
        }

        public org.kie.kogito.examples.OrderItemsProcess createOrderItemsProcess() {
            return new org.kie.kogito.examples.OrderItemsProcess(Application.this).configure();
        }

        public org.kie.kogito.examples.OrdersProcess createOrdersProcess() {
            return new org.kie.kogito.examples.OrdersProcess(Application.this).configure();
        }
    }
}
