package org.kie.kogito.examples;

import org.kie.kogito.Config;
import org.kie.kogito.process.Processes;
import org.kie.kogito.uow.UnitOfWorkManager;

@org.springframework.stereotype.Component()
public class Application implements org.kie.kogito.Application {

    @org.springframework.beans.factory.annotation.Autowired(required = false)
    java.util.List<org.kie.kogito.event.EventPublisher> eventPublishers;

    @org.springframework.beans.factory.annotation.Value("${kogito.service.url:#{null}}")
    java.util.Optional<java.lang.String> kogitoService;

    @org.springframework.beans.factory.annotation.Autowired()
    org.kie.kogito.Config config;

    RuleUnits ruleUnits = new RuleUnits();

    Processes processes = new Processes();

    public Config config() {
        return config;
    }

    public UnitOfWorkManager unitOfWorkManager() {
        return config().process().unitOfWorkManager();
    }

    @javax.annotation.PostConstruct()
    public void setup() {
        if (config().process() != null) {
            if (eventPublishers != null) {
                eventPublishers.forEach(publisher -> unitOfWorkManager().eventManager().addPublisher(publisher));
            }
            unitOfWorkManager().eventManager().setService(kogitoService.orElse(""));
            unitOfWorkManager().eventManager().setAddons(config().addons());
        }
    }

    public RuleUnits ruleUnits() {
        return ruleUnits;
    }

    public class RuleUnits extends org.kie.kogito.rules.units.impl.AbstractRuleUnits {

        org.kie.kogito.rules.KieRuntimeBuilder ruleRuntimeBuilder = new org.drools.project.model.ProjectRuntime();

        public org.kie.kogito.rules.KieRuntimeBuilder ruleRuntimeBuilder() {
            return this.ruleRuntimeBuilder;
        }

        protected org.kie.kogito.rules.RuleUnit<?> create(String fqcn) {
            switch(fqcn) {
                default:
                    throw new java.lang.UnsupportedOperationException();
            }
        }
    }

    public Processes processes() {
        return processes;
    }

    public class Processes implements org.kie.kogito.process.Processes {

        public org.kie.kogito.process.Process<? extends org.kie.kogito.Model> processById(String processId) {
            if ("persons".equals(processId))
                return new org.kie.kogito.examples.demo.PersonsProcess(Application.this).configure();
            if ("demo.orderItems".equals(processId))
                return new org.kie.kogito.examples.OrderItemsProcess(Application.this).configure();
            if ("demo.orders".equals(processId))
                return new org.kie.kogito.examples.OrdersProcess(Application.this).configure();
            return null;
        }

        public java.util.Collection<String> processIds() {
            return java.util.Arrays.asList("persons", "demo.orderItems", "demo.orders");
        }
    }
}
