package org.kie.kogito.examples;

import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.ProcessEventListenerConfig;
import org.kie.kogito.process.WorkItemHandlerConfig;
import org.kie.kogito.rules.RuleConfig;
import org.kie.kogito.rules.RuleEventListenerConfig;
import org.kie.kogito.uow.UnitOfWorkManager;

@org.springframework.stereotype.Component()
public class ApplicationConfig implements org.kie.kogito.Config {

    protected ProcessConfig processConfig;

    protected RuleConfig ruleConfig;

    private org.kie.kogito.process.ProcessEventListenerConfig defaultProcessEventListenerConfig = new org.kie.kogito.process.impl.DefaultProcessEventListenerConfig();

    private org.kie.kogito.process.WorkItemHandlerConfig defaultWorkItemHandlerConfig = new org.kie.kogito.process.impl.DefaultWorkItemHandlerConfig();

    private org.kie.kogito.uow.UnitOfWorkManager defaultUnitOfWorkManager = new org.kie.kogito.services.uow.DefaultUnitOfWorkManager(new org.kie.kogito.services.uow.CollectingUnitOfWorkFactory());

    private org.kie.kogito.jobs.JobsService defaultJobsService = null;

    @org.springframework.beans.factory.annotation.Autowired()
    java.util.Optional<org.kie.kogito.process.ProcessEventListenerConfig> processEventListenerConfig;

    @org.springframework.beans.factory.annotation.Autowired()
    java.util.Optional<org.kie.kogito.process.WorkItemHandlerConfig> workItemHandlerConfig;

    @org.springframework.beans.factory.annotation.Autowired()
    java.util.Optional<org.kie.kogito.uow.UnitOfWorkManager> unitOfWorkManager;

    @org.springframework.beans.factory.annotation.Autowired()
    java.util.Optional<org.kie.kogito.jobs.JobsService> jobsService;

    private org.kie.kogito.rules.RuleEventListenerConfig defaultRuleEventListenerConfig = new org.drools.core.config.DefaultRuleEventListenerConfig();

    @org.springframework.beans.factory.annotation.Autowired()
    java.util.Optional<org.kie.kogito.rules.RuleEventListenerConfig> ruleEventListenerConfig;

    @Override
    public ProcessConfig process() {
        return processConfig;
    }

    @Override
    public RuleConfig rule() {
        return ruleConfig;
    }

    protected org.kie.kogito.process.WorkItemHandlerConfig extract_workItemHandlerConfig() {
        if (workItemHandlerConfig.isPresent())
            return workItemHandlerConfig.get();
        else
            return defaultWorkItemHandlerConfig;
    }

    protected org.kie.kogito.process.ProcessEventListenerConfig extract_processEventListenerConfig() {
        if (processEventListenerConfig.isPresent())
            return processEventListenerConfig.get();
        else
            return defaultProcessEventListenerConfig;
    }

    protected org.kie.kogito.uow.UnitOfWorkManager extract_unitOfWorkManager() {
        if (unitOfWorkManager.isPresent())
            return unitOfWorkManager.get();
        else
            return defaultUnitOfWorkManager;
    }

    protected org.kie.kogito.jobs.JobsService extract_jobsService() {
        if (jobsService.isPresent())
            return jobsService.get();
        else
            return defaultJobsService;
    }

    protected org.kie.kogito.rules.RuleEventListenerConfig extract_ruleEventListenerConfig() {
        if (ruleEventListenerConfig.isPresent())
            return ruleEventListenerConfig.get();
        else
            return defaultRuleEventListenerConfig;
    }

    public org.kie.kogito.Addons addons() {
        return new org.kie.kogito.Addons(java.util.Arrays.asList("process-management"));
    }

    @javax.annotation.PostConstruct()
    public void init() {
        processConfig = new org.kie.kogito.process.impl.StaticProcessConfig(extract_workItemHandlerConfig(), extract_processEventListenerConfig(), extract_unitOfWorkManager(), extract_jobsService());
        ruleConfig = new org.drools.core.config.StaticRuleConfig(extract_ruleEventListenerConfig());
    }
}
