/*
 * Decompiled with CFR 0.152.
 */
package org.kogito.examples.sw.notification.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.ProducerTemplate;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Path(value="")
@ApplicationScoped
public class NotificationResource {
    @Inject
    ObjectMapper mapper;
    @Inject
    ProducerTemplate producerTemplate;
    @ConfigProperty(name="org.kogito.examples.sw.notification.slack.channel")
    String channel;
    @ConfigProperty(name="org.kogito.examples.sw.notification.slack.incoming")
    String webHookUrl;

    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @Path(value="/plain")
    public Response createSlackMessage(String message) {
        this.producerTemplate.requestBody("slack:#" + this.channel + "?webhookUrl=" + this.webHookUrl, (Object)message);
        return Response.ok().build();
    }

    @POST
    public Response createSlackMessage(CloudEvent message) throws IOException {
        this.producerTemplate.requestBody("slack:#" + this.channel + "?webhookUrl=" + this.webHookUrl, (Object)this.formatMessageFromCE(message));
        return Response.ok().build();
    }

    private String formatMessageFromCE(CloudEvent message) throws IOException {
        JsonNode jsonNode = this.mapper.readTree(message.getData().toBytes());
        return String.format("Heads Up! *%s* event on PR *#%s*, named *%s*", message.getType(), jsonNode.get("number").asText(), jsonNode.get("pull_request").get("title").asText());
    }
}

