package org.kie.kogito.examples.onboarding;

import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.ruleflow.core.RuleFlowProcessFactory;
import org.drools.core.util.KieFunctions;

@org.springframework.stereotype.Component("onboarding.setupPayroll")
public class SetupPayrollProcess extends org.kie.kogito.process.impl.AbstractProcess<org.kie.kogito.examples.onboarding.SetupPayrollModel> {

    @org.springframework.beans.factory.annotation.Autowired(required = false)
    java.util.Collection<org.kie.api.runtime.process.WorkItemHandler> handlers;

    org.kie.kogito.examples.Application app;

    public SetupPayrollProcess() {
    }

    @org.springframework.beans.factory.annotation.Autowired()
    public SetupPayrollProcess(org.kie.kogito.examples.Application app) {
        super(app.config().process());
        this.app = app;
    }

    public org.kie.kogito.examples.onboarding.SetupPayrollProcessInstance createInstance(org.kie.kogito.examples.onboarding.SetupPayrollModel value) {
        return new org.kie.kogito.examples.onboarding.SetupPayrollProcessInstance(this, value, this.createLegacyProcessRuntime());
    }

    public org.kie.kogito.examples.onboarding.SetupPayrollProcessInstance createInstance(java.lang.String businessKey, org.kie.kogito.examples.onboarding.SetupPayrollModel value) {
        return new org.kie.kogito.examples.onboarding.SetupPayrollProcessInstance(this, value, businessKey, this.createLegacyProcessRuntime());
    }

    public org.kie.kogito.examples.onboarding.SetupPayrollModel createModel() {
        return new org.kie.kogito.examples.onboarding.SetupPayrollModel();
    }

    public org.kie.kogito.examples.onboarding.SetupPayrollProcessInstance createInstance(org.kie.kogito.Model value) {
        return this.createInstance((org.kie.kogito.examples.onboarding.SetupPayrollModel) value);
    }

    public org.kie.kogito.examples.onboarding.SetupPayrollProcessInstance createInstance(java.lang.String businessKey, org.kie.kogito.Model value) {
        return this.createInstance(businessKey, (org.kie.kogito.examples.onboarding.SetupPayrollModel) value);
    }

    public SetupPayrollProcess configure() {
        super.configure();
        return this;
    }

    protected void registerListeners() {
    }

    public org.kie.api.definition.process.Process legacyProcess() {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess("onboarding.setupPayroll");
        factory.variable("employee", new ObjectDataType("org.kie.kogito.examples.onboarding.Employee"), "customTags", null);
        factory.variable("payroll", new ObjectDataType("org.kie.kogito.examples.onboarding.Payroll"), "customTags", null);
        factory.variable("vacationDays", new ObjectDataType("java.lang.Integer"), "customTags", null);
        factory.variable("taxRate", new ObjectDataType("java.lang.Double"), "customTags", null);
        factory.variable("paymentDate", new ObjectDataType("java.util.Date"), "customTags", null);
        factory.name("setupPayroll");
        factory.packageName("org.kie.kogito.examples.onboarding");
        factory.dynamic(false);
        factory.version("1.0");
        factory.visibility("Private");
        factory.metaData("Documentation", "Calculates payroll related data such as vacation days, tax rate, payment date, etc");
        factory.metaData("TargetNamespace", "http://www.omg.org/bpmn20");
        org.jbpm.ruleflow.core.factory.WorkItemNodeFactory workItemNode1 = factory.workItemNode(1);
        workItemNode1.name("Calculate payment date");
        workItemNode1.workName("CalculatePaymentDate");
        workItemNode1.workParameter("Decision", "payments/date");
        workItemNode1.workParameter("Model", "onboarding");
        workItemNode1.workParameter("Namespace", "test");
        workItemNode1.workParameter("TaskName", "CalculatePaymentDate");
        workItemNode1.inMapping("employee", "employee");
        workItemNode1.outMapping("paymentDate", "paymentDate");
        workItemNode1.done();
        workItemNode1.metaData("UniqueId", "_83EB46B5-7186-4575-8AA0-1A8FCCE1D163");
        workItemNode1.metaData("elementname", "Calculate payment date");
        workItemNode1.metaData("x", 392);
        workItemNode1.metaData("width", 154);
        workItemNode1.metaData("y", 355);
        workItemNode1.metaData("height", 102);
        org.jbpm.ruleflow.core.factory.JoinFactory joinNode2 = factory.joinNode(2);
        joinNode2.name("Join");
        joinNode2.type(5);
        joinNode2.metaData("UniqueId", "_242EB204-4239-4DAA-8E4F-A160039547A2");
        joinNode2.metaData("x", 629);
        joinNode2.metaData("width", 56);
        joinNode2.metaData("y", 213);
        joinNode2.metaData("height", 56);
        joinNode2.done();
        org.jbpm.ruleflow.core.factory.SplitFactory splitNode3 = factory.splitNode(3);
        splitNode3.name("Split");
        splitNode3.type(3);
        splitNode3.metaData("UniqueId", "_FC492E95-B79A-4EE3-B7FC-0A0197516421");
        splitNode3.metaData("x", 253);
        splitNode3.metaData("width", 56);
        splitNode3.metaData("y", 213);
        splitNode3.metaData("height", 56);
        splitNode3.constraint(1, "_B94F71D7-E34E-4513-B06D-33F6EF74C9E6", "DROOLS_DEFAULT", "java", kcontext -> {
            org.kie.kogito.examples.onboarding.Employee employee = (org.kie.kogito.examples.onboarding.Employee) kcontext.getVariable("employee");
            org.kie.kogito.examples.onboarding.Payroll payroll = (org.kie.kogito.examples.onboarding.Payroll) kcontext.getVariable("payroll");
            java.lang.Integer vacationDays = (java.lang.Integer) kcontext.getVariable("vacationDays");
            java.lang.Double taxRate = (java.lang.Double) kcontext.getVariable("taxRate");
            java.util.Date paymentDate = (java.util.Date) kcontext.getVariable("paymentDate");
            {
                return employee.getAddress().getCountry().equalsIgnoreCase("US");
            }
        }, 0);
        splitNode3.constraint(6, "_622BF92E-6590-44B6-B83D-10C0D8067D09", "DROOLS_DEFAULT", "java", kcontext -> {
            org.kie.kogito.examples.onboarding.Employee employee = (org.kie.kogito.examples.onboarding.Employee) kcontext.getVariable("employee");
            org.kie.kogito.examples.onboarding.Payroll payroll = (org.kie.kogito.examples.onboarding.Payroll) kcontext.getVariable("payroll");
            java.lang.Integer vacationDays = (java.lang.Integer) kcontext.getVariable("vacationDays");
            java.lang.Double taxRate = (java.lang.Double) kcontext.getVariable("taxRate");
            java.util.Date paymentDate = (java.util.Date) kcontext.getVariable("paymentDate");
            {
                return true;
            }
        }, 0);
        splitNode3.constraint(4, "_A9F2A40F-0EAD-4241-908B-F7A950DAC100", "DROOLS_DEFAULT", "java", kcontext -> {
            org.kie.kogito.examples.onboarding.Employee employee = (org.kie.kogito.examples.onboarding.Employee) kcontext.getVariable("employee");
            org.kie.kogito.examples.onboarding.Payroll payroll = (org.kie.kogito.examples.onboarding.Payroll) kcontext.getVariable("payroll");
            java.lang.Integer vacationDays = (java.lang.Integer) kcontext.getVariable("vacationDays");
            java.lang.Double taxRate = (java.lang.Double) kcontext.getVariable("taxRate");
            java.util.Date paymentDate = (java.util.Date) kcontext.getVariable("paymentDate");
            {
                return true;
            }
        }, 0);
        splitNode3.done();
        org.jbpm.ruleflow.core.factory.WorkItemNodeFactory workItemNode4 = factory.workItemNode(4);
        workItemNode4.name("Calculate vacation days");
        workItemNode4.workName("CalculateVacationDays");
        workItemNode4.workParameter("Model", "onboarding");
        workItemNode4.workParameter("Namespace", "test");
        workItemNode4.workParameter("Decision", "vacations/days");
        workItemNode4.workParameter("TaskName", "CalculateVacationDays");
        workItemNode4.inMapping("employee", "employee");
        workItemNode4.outMapping("vacationDays", "vacationDays");
        workItemNode4.done();
        workItemNode4.metaData("UniqueId", "_AE1BFAA6-7AFD-455F-95B4-FA619A2095CF");
        workItemNode4.metaData("elementname", "Calculate vacation days");
        workItemNode4.metaData("Documentation", "Uses VacationDays decision service to calculate eligible vacation days for the employee");
        workItemNode4.metaData("x", 392);
        workItemNode4.metaData("width", 154);
        workItemNode4.metaData("y", 25);
        workItemNode4.metaData("height", 102);
        org.jbpm.ruleflow.core.factory.StartNodeFactory startNode5 = factory.startNode(5);
        startNode5.name("Start");
        startNode5.interrupting(true);
        startNode5.metaData("UniqueId", "_7E4BB129-666E-4805-ADB1-A43F6EEEE0D8");
        startNode5.metaData("x", 117);
        startNode5.metaData("width", 56);
        startNode5.metaData("y", 213);
        startNode5.metaData("height", 56);
        startNode5.done();
        org.jbpm.ruleflow.core.factory.WorkItemNodeFactory workItemNode6 = factory.workItemNode(6);
        workItemNode6.name("Calculate tax rate");
        workItemNode6.workName("CalculateTaxRate");
        workItemNode6.workParameter("Decision", "taxes/rate");
        workItemNode6.workParameter("Model", "onboarding");
        workItemNode6.workParameter("Namespace", "test");
        workItemNode6.workParameter("TaskName", "CalculateTaxRate");
        workItemNode6.inMapping("employee", "employee");
        workItemNode6.outMapping("taxRate", "taxRate");
        workItemNode6.done();
        workItemNode6.metaData("UniqueId", "_D2DE6249-804E-432D-9600-6B0F618B457C");
        workItemNode6.metaData("elementname", "Calculate tax rate");
        workItemNode6.metaData("x", 392);
        workItemNode6.metaData("width", 154);
        workItemNode6.metaData("y", 190);
        workItemNode6.metaData("height", 102);
        org.jbpm.ruleflow.core.factory.ActionNodeFactory actionNode7 = factory.actionNode(7);
        actionNode7.name("Payroll setup");
        actionNode7.action(kcontext -> {
            org.kie.kogito.examples.onboarding.Payroll payroll = (org.kie.kogito.examples.onboarding.Payroll) kcontext.getVariable("payroll");
            java.lang.Integer vacationDays = (java.lang.Integer) kcontext.getVariable("vacationDays");
            java.lang.Double taxRate = (java.lang.Double) kcontext.getVariable("taxRate");
            java.util.Date paymentDate = (java.util.Date) kcontext.getVariable("paymentDate");
            org.kie.kogito.examples.onboarding.Payroll empPayroll = new org.kie.kogito.examples.onboarding.Payroll(vacationDays, taxRate, paymentDate);

kcontext.setVariable("payroll", empPayroll);;
        });
        actionNode7.metaData("UniqueId", "_9E55D729-F4A6-4829-8BB9-79742D9008C5");
        actionNode7.metaData("elementname", "Payroll setup");
        actionNode7.metaData("NodeType", "ScriptTask");
        actionNode7.metaData("x", 765);
        actionNode7.metaData("width", 154);
        actionNode7.metaData("y", 190);
        actionNode7.metaData("height", 102);
        actionNode7.done();
        org.jbpm.ruleflow.core.factory.EndNodeFactory endNode8 = factory.endNode(8);
        endNode8.name("End Event 1");
        endNode8.terminate(false);
        endNode8.metaData("UniqueId", "EndEvent_1");
        endNode8.metaData("elementname", "End Event 1");
        endNode8.metaData("x", 1000);
        endNode8.metaData("width", 36);
        endNode8.metaData("y", 223);
        endNode8.metaData("height", 36);
        endNode8.done();
        factory.connection(3, 1, "_B94F71D7-E34E-4513-B06D-33F6EF74C9E6");
        factory.connection(1, 2, "_344D9BF6-D173-4BEC-943B-5E4394A6B6C7");
        factory.connection(4, 2, "_FDBE0EF0-FA3E-4FEC-8568-7E7A79A5289E");
        factory.connection(6, 2, "_7597C8A1-CC2B-4345-99A2-3F3A71C1FDA1");
        factory.connection(5, 3, "_299404B8-2860-4F4D-B970-48F6B17DA3E9");
        factory.connection(3, 4, "_A9F2A40F-0EAD-4241-908B-F7A950DAC100");
        factory.connection(3, 6, "_622BF92E-6590-44B6-B83D-10C0D8067D09");
        factory.connection(2, 7, "_7B55F281-D560-4130-88C9-177C960E8682");
        factory.connection(7, 8, "SequenceFlow_3");
        factory.validate();
        return factory.getProcess();
    }

    @javax.annotation.PostConstruct()
    public void init() {
        this.activate();
    }
}
