package org.kie.kogito.examples.onboarding;

import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.ruleflow.core.RuleFlowProcessFactory;
import org.drools.core.util.KieFunctions;

@org.springframework.stereotype.Component("onboarding.onboarding")
public class OnboardingProcess extends org.kie.kogito.process.impl.AbstractProcess<org.kie.kogito.examples.onboarding.OnboardingModel> {

    @org.springframework.beans.factory.annotation.Autowired(required = false)
    java.util.Collection<org.kie.api.runtime.process.WorkItemHandler> handlers;

    org.kie.kogito.examples.Application app;

    @org.springframework.beans.factory.annotation.Autowired()
    org.kie.kogito.process.Process<SetupHRModel> processsetupHR;

    @org.springframework.beans.factory.annotation.Autowired()
    org.kie.kogito.process.Process<SetupPayrollModel> processsetupPayroll;

    public OnboardingProcess() {
    }

    @org.springframework.beans.factory.annotation.Autowired()
    public OnboardingProcess(org.kie.kogito.examples.Application app) {
        super(app.config().process());
        this.app = app;
    }

    public org.kie.kogito.examples.onboarding.OnboardingProcessInstance createInstance(org.kie.kogito.examples.onboarding.OnboardingModel value) {
        return new org.kie.kogito.examples.onboarding.OnboardingProcessInstance(this, value, this.createProcessRuntime());
    }

    public org.kie.kogito.examples.onboarding.OnboardingProcessInstance createInstance(java.lang.String businessKey, org.kie.kogito.examples.onboarding.OnboardingModel value) {
        return new org.kie.kogito.examples.onboarding.OnboardingProcessInstance(this, value, businessKey, this.createProcessRuntime());
    }

    public org.kie.kogito.examples.onboarding.OnboardingModel createModel() {
        return new org.kie.kogito.examples.onboarding.OnboardingModel();
    }

    public org.kie.kogito.examples.onboarding.OnboardingProcessInstance createInstance(org.kie.kogito.Model value) {
        return this.createInstance((org.kie.kogito.examples.onboarding.OnboardingModel) value);
    }

    public org.kie.kogito.examples.onboarding.OnboardingProcessInstance createInstance(java.lang.String businessKey, org.kie.kogito.Model value) {
        return this.createInstance(businessKey, (org.kie.kogito.examples.onboarding.OnboardingModel) value);
    }

    public org.kie.kogito.examples.onboarding.OnboardingProcessInstance createInstance(org.kie.api.runtime.process.WorkflowProcessInstance wpi) {
        return new org.kie.kogito.examples.onboarding.OnboardingProcessInstance(this, this.createModel(), this.createProcessRuntime(), wpi);
    }

    public OnboardingProcess configure() {
        super.configure();
        return this;
    }

    protected void registerListeners() {
        services.getSignalManager().addEventListener("onboarding.setupHR", completionEventListener);
        services.getSignalManager().addEventListener("onboarding.setupPayroll", completionEventListener);
    }

    public org.kie.api.definition.process.Process process() {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess("onboarding.onboarding");
        factory.variable("employee", new ObjectDataType("org.kie.kogito.examples.onboarding.Employee"), "customTags", null);
        factory.variable("payroll", new ObjectDataType("org.kie.kogito.examples.onboarding.Payroll"), "customTags", null);
        factory.variable("employeeId", new ObjectDataType("java.lang.String"), "customTags", null);
        factory.variable("email", new ObjectDataType("java.lang.String"), "customTags", null);
        factory.variable("status", new ObjectDataType("java.lang.String"), "customTags", null);
        factory.variable("message", new ObjectDataType("java.lang.String"), "customTags", null);
        factory.variable("manager", new ObjectDataType("java.lang.String"), "customTags", null);
        factory.variable("department", new ObjectDataType("java.lang.String"), "customTags", null);
        factory.name("onboarding");
        factory.packageName("org.kie.kogito.examples.onboarding");
        factory.dynamic(false);
        factory.version("1.0");
        factory.visibility("Public");
        factory.metaData("TargetNamespace", "http://www.omg.org/bpmn20");
        org.jbpm.ruleflow.core.factory.SplitFactory splitNode1 = factory.splitNode(1);
        splitNode1.name("Split");
        splitNode1.type(1);
        splitNode1.metaData("UniqueId", "_EEA9F9A8-BC9D-4DC3-B89A-28F79A0C6A48");
        splitNode1.metaData("x", 801);
        splitNode1.metaData("width", 56);
        splitNode1.metaData("y", 232);
        splitNode1.metaData("height", 56);
        splitNode1.done();
        org.jbpm.ruleflow.core.factory.StartNodeFactory startNode2 = factory.startNode(2);
        startNode2.name("Start");
        startNode2.interrupting(true);
        startNode2.metaData("UniqueId", "_1EA961BC-6E42-4F0E-ACC4-B3A06137B9E8");
        startNode2.metaData("x", 90);
        startNode2.metaData("width", 56);
        startNode2.metaData("y", 232);
        startNode2.metaData("height", 56);
        startNode2.done();
        org.jbpm.ruleflow.core.factory.HumanTaskNodeFactory humanTaskNode3 = factory.humanTaskNode(3);
        humanTaskNode3.name("Manager confirmation");
        humanTaskNode3.workParameter("TaskName", "ManagerConfirmation");
        humanTaskNode3.workParameter("Skippable", "false");
        humanTaskNode3.workParameter("ActorId", "manager");
        humanTaskNode3.workParameter("NodeName", "Manager confirmation");
        humanTaskNode3.inMapping("depeartment", "department");
        humanTaskNode3.inMapping("employeeId", "employeeId");
        humanTaskNode3.inMapping("payroll", "payroll");
        humanTaskNode3.inMapping("employee", "employee");
        humanTaskNode3.inMapping("email", "email");
        humanTaskNode3.outMapping("message", "message");
        humanTaskNode3.outMapping("status", "status");
        humanTaskNode3.done();
        humanTaskNode3.metaData("UniqueId", "_55258880-C191-4643-AC16-A0F5C1B05956");
        humanTaskNode3.metaData("elementname", "Manager confirmation");
        humanTaskNode3.metaData("x", 1162);
        humanTaskNode3.metaData("width", 154);
        humanTaskNode3.metaData("y", 336);
        humanTaskNode3.metaData("height", 102);
        org.jbpm.ruleflow.core.factory.SplitFactory splitNode4 = factory.splitNode(4);
        splitNode4.name("Split");
        splitNode4.type(2);
        splitNode4.metaData("UniqueId", "_32221BB1-BAE5-4431-8003-3FEF0E04D9C7");
        splitNode4.metaData("x", 431);
        splitNode4.metaData("width", 56);
        splitNode4.metaData("y", 232);
        splitNode4.metaData("Default", "_A65F4850-A93F-4703-B5AA-2EF5F649BC86");
        splitNode4.metaData("height", 56);
        splitNode4.constraint(10, "_5F4F4E2D-B4EC-4542-91DF-69FC30C5E346", "DROOLS_DEFAULT", "java", kcontext -> {
            org.kie.kogito.examples.onboarding.Employee employee = (org.kie.kogito.examples.onboarding.Employee) kcontext.getVariable("employee");
            org.kie.kogito.examples.onboarding.Payroll payroll = (org.kie.kogito.examples.onboarding.Payroll) kcontext.getVariable("payroll");
            java.lang.String employeeId = (java.lang.String) kcontext.getVariable("employeeId");
            java.lang.String email = (java.lang.String) kcontext.getVariable("email");
            java.lang.String status = (java.lang.String) kcontext.getVariable("status");
            java.lang.String message = (java.lang.String) kcontext.getVariable("message");
            java.lang.String manager = (java.lang.String) kcontext.getVariable("manager");
            java.lang.String department = (java.lang.String) kcontext.getVariable("department");
            {
                return KieFunctions.equalsTo(status, "exists");
            }
        }, 0);
        splitNode4.constraint(11, "_A65F4850-A93F-4703-B5AA-2EF5F649BC86", "DROOLS_DEFAULT", "java", kcontext -> {
            org.kie.kogito.examples.onboarding.Employee employee = (org.kie.kogito.examples.onboarding.Employee) kcontext.getVariable("employee");
            org.kie.kogito.examples.onboarding.Payroll payroll = (org.kie.kogito.examples.onboarding.Payroll) kcontext.getVariable("payroll");
            java.lang.String employeeId = (java.lang.String) kcontext.getVariable("employeeId");
            java.lang.String email = (java.lang.String) kcontext.getVariable("email");
            java.lang.String status = (java.lang.String) kcontext.getVariable("status");
            java.lang.String message = (java.lang.String) kcontext.getVariable("message");
            java.lang.String manager = (java.lang.String) kcontext.getVariable("manager");
            java.lang.String department = (java.lang.String) kcontext.getVariable("department");
            {
                return KieFunctions.equalsTo(status, "new");
            }
        }, 0);
        splitNode4.done();
        org.jbpm.ruleflow.core.factory.SubProcessNodeFactory subProcessNode5 = factory.subProcessNode(5);
        subProcessNode5.name("Setup HR");
        subProcessNode5.processId("onboarding.setupHR");
        subProcessNode5.processName("");
        subProcessNode5.waitForCompletion(true);
        subProcessNode5.independent(false);
        subProcessNode5.subProcessNode(new org.jbpm.workflow.core.node.SubProcessFactory<SetupHRModel>() {

            public SetupHRModel bind(org.kie.api.runtime.process.ProcessContext kcontext) {
                org.kie.kogito.examples.onboarding.SetupHRModel model = new org.kie.kogito.examples.onboarding.SetupHRModel();
                org.kie.kogito.examples.onboarding.Employee employee = (org.kie.kogito.examples.onboarding.Employee) kcontext.getVariable("employee");
                model.setEmployee((org.kie.kogito.examples.onboarding.Employee) (employee));
                return model;
            }

            public org.kie.kogito.process.ProcessInstance<SetupHRModel> createInstance(SetupHRModel model) {
                return processsetupHR.createInstance(model);
            }

            public void unbind(org.kie.api.runtime.process.ProcessContext kcontext, SetupHRModel model) {
                java.lang.String manager = (java.lang.String) model.getManager();
                kcontext.setVariable("manager", manager);
                java.lang.String department = (java.lang.String) model.getDepartment();
                kcontext.setVariable("department", department);
            }
        });
        subProcessNode5.metaData("UniqueId", "_14472369-3EAD-4B2D-9C3B-F83D4630C59B");
        subProcessNode5.metaData("elementname", "Setup HR");
        subProcessNode5.metaData("x", 929);
        subProcessNode5.metaData("width", 153);
        subProcessNode5.metaData("y", 337);
        subProcessNode5.metaData("height", 101);
        subProcessNode5.done();
        org.jbpm.ruleflow.core.factory.EndNodeFactory endNode6 = factory.endNode(6);
        endNode6.name("End");
        endNode6.terminate(false);
        endNode6.metaData("UniqueId", "_F6920526-06EC-43CD-A743-17778DEB7363");
        endNode6.metaData("x", 1501);
        endNode6.metaData("width", 56);
        endNode6.metaData("y", 232);
        endNode6.metaData("height", 56);
        endNode6.done();
        org.jbpm.ruleflow.core.factory.WorkItemNodeFactory workItemNode7 = factory.workItemNode(7);
        workItemNode7.name("Validate employee");
        workItemNode7.workName("ValidateEmployee");
        workItemNode7.workParameter("Decision", "employee-validation/first");
        workItemNode7.workParameter("Model", "onboarding");
        workItemNode7.workParameter("Namespace", "test");
        workItemNode7.workParameter("TaskName", "ValidateEmployee");
        workItemNode7.inMapping("employee", "employee");
        workItemNode7.outMapping("message", "message");
        workItemNode7.outMapping("status", "status");
        workItemNode7.done();
        workItemNode7.metaData("UniqueId", "_DD24B4AE-8804-4D6E-B90B-98689CF6EF37");
        workItemNode7.metaData("elementname", "Validate employee");
        workItemNode7.metaData("x", 197);
        workItemNode7.metaData("width", 154);
        workItemNode7.metaData("y", 209);
        workItemNode7.metaData("height", 102);
        org.jbpm.ruleflow.core.factory.SubProcessNodeFactory subProcessNode8 = factory.subProcessNode(8);
        subProcessNode8.name("Setup Payroll");
        subProcessNode8.processId("onboarding.setupPayroll");
        subProcessNode8.processName("");
        subProcessNode8.waitForCompletion(true);
        subProcessNode8.independent(false);
        subProcessNode8.subProcessNode(new org.jbpm.workflow.core.node.SubProcessFactory<SetupPayrollModel>() {

            public SetupPayrollModel bind(org.kie.api.runtime.process.ProcessContext kcontext) {
                org.kie.kogito.examples.onboarding.SetupPayrollModel model = new org.kie.kogito.examples.onboarding.SetupPayrollModel();
                org.kie.kogito.examples.onboarding.Employee employee = (org.kie.kogito.examples.onboarding.Employee) kcontext.getVariable("employee");
                model.setEmployee((org.kie.kogito.examples.onboarding.Employee) (employee));
                return model;
            }

            public org.kie.kogito.process.ProcessInstance<SetupPayrollModel> createInstance(SetupPayrollModel model) {
                return processsetupPayroll.createInstance(model);
            }

            public void unbind(org.kie.api.runtime.process.ProcessContext kcontext, SetupPayrollModel model) {
                org.kie.kogito.examples.onboarding.Payroll payroll = (org.kie.kogito.examples.onboarding.Payroll) model.getPayroll();
                kcontext.setVariable("payroll", payroll);
            }
        });
        subProcessNode8.metaData("UniqueId", "_9D7A4927-BFCB-4F17-A4D4-E3D03B3FBE49");
        subProcessNode8.metaData("elementname", "Setup Payroll");
        subProcessNode8.metaData("x", 929);
        subProcessNode8.metaData("width", 153);
        subProcessNode8.metaData("y", 81);
        subProcessNode8.metaData("height", 101);
        subProcessNode8.done();
        org.jbpm.ruleflow.core.factory.JoinFactory joinNode9 = factory.joinNode(9);
        joinNode9.name("Join");
        joinNode9.type(1);
        joinNode9.metaData("UniqueId", "_E918E3F5-CB0B-4875-AD72-5C8337D3C69A");
        joinNode9.metaData("x", 1365);
        joinNode9.metaData("width", 56);
        joinNode9.metaData("y", 232);
        joinNode9.metaData("height", 56);
        joinNode9.done();
        org.jbpm.ruleflow.core.factory.FaultNodeFactory faultNode10 = factory.faultNode(10);
        faultNode10.name("Error");
        faultNode10.faultName("Rejected");
        faultNode10.metaData("UniqueId", "_469F11CB-CA82-4CA0-ACC4-127F6B3727F1");
        faultNode10.metaData("x", 537);
        faultNode10.metaData("width", 56);
        faultNode10.metaData("y", 451);
        faultNode10.metaData("height", 56);
        faultNode10.done();
        org.jbpm.ruleflow.core.factory.WorkItemNodeFactory workItemNode11 = factory.workItemNode(11);
        workItemNode11.name("Assign id and email");
        workItemNode11.workName("AssignIdAndEmail");
        workItemNode11.workParameter("Decision", "id");
        workItemNode11.workParameter("Model", "onboarding");
        workItemNode11.workParameter("Namespace", "test");
        workItemNode11.workParameter("TaskName", "AssignIdAndEmail");
        workItemNode11.inMapping("employee", "employee");
        workItemNode11.outMapping("employeeId", "employeeId");
        workItemNode11.outMapping("email", "email");
        workItemNode11.done();
        workItemNode11.metaData("UniqueId", "_16FFBBF8-8373-46D4-A278-F305AFA7F4B1");
        workItemNode11.metaData("elementname", "Assign id and email");
        workItemNode11.metaData("x", 567);
        workItemNode11.metaData("width", 154);
        workItemNode11.metaData("y", 209);
        workItemNode11.metaData("height", 102);
        factory.connection(11, 1, "_7DF7D2C1-195D-4C19-BC47-CC4462F9062D");
        factory.connection(5, 3, "_D32B4A20-53D1-46F3-95F6-276A2392931F");
        factory.connection(7, 4, "_5A442C9F-BADA-4D95-9ECA-3BD2898C8377");
        factory.connection(1, 5, "_D5E3808E-4D68-4B8F-939D-17C7643E58FD");
        factory.connection(9, 6, "_3CFB2AC2-17B6-4322-ACD8-C9A149975143");
        factory.connection(2, 7, "_9D72C909-B631-415E-B015-30812A42B8C2");
        factory.connection(1, 8, "_DF6979D3-AFD3-4BC8-A866-8B9214F7F0FB");
        factory.connection(3, 9, "_44ABA3C5-9A26-4843-B03B-99C2C0251707");
        factory.connection(8, 9, "_BB67B9E9-611B-4B17-A6F9-3CD4DCA4B249");
        factory.connection(4, 10, "_5F4F4E2D-B4EC-4542-91DF-69FC30C5E346");
        factory.connection(4, 11, "_A65F4850-A93F-4703-B5AA-2EF5F649BC86");
        factory.validate();
        return factory.getProcess();
    }

    @javax.annotation.PostConstruct()
    public void init() {
        this.activate();
    }
}
