/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples.onboarding;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.kie.kogito.Application;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.examples.onboarding.SetupHRModel;
import org.kie.kogito.examples.onboarding.SetupHRModelOutput;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.services.identity.StaticIdentityProvider;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Path(value="/setupHR")
@Component
public class SetupHRResource {
    @Autowired
    @Qualifier(value="onboarding.setupHR")
    Process<SetupHRModel> process;
    @Autowired
    Application application;

    @GET
    @Produces(value={"application/json"})
    public List<SetupHRModelOutput> getResources_setupHR() {
        return this.process.instances().values().stream().map(pi -> ((SetupHRModel)pi.variables()).toOutput()).collect(Collectors.toList());
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public SetupHRModelOutput getResource_setupHR(@PathParam(value="id") String id) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> ((SetupHRModel)pi.variables()).toOutput()).orElse(null);
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public SetupHRModelOutput deleteResource_setupHR(@PathParam(value="id") String id) {
        return (SetupHRModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.abort();
            return ((SetupHRModel)pi.checkError().variables()).toOutput();
        }).orElse(null));
    }

    @POST
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public SetupHRModelOutput updateModel_setupHR(@PathParam(value="id") String id, SetupHRModel resource) {
        return (SetupHRModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> ((SetupHRModel)pi.updateVariables((Object)resource)).toOutput()).orElse(null));
    }

    @GET
    @Path(value="/{id}/tasks")
    @Produces(value={"application/json"})
    public Map<String, String> getTasks_setupHR(@PathParam(value="id") String id, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> pi.workItems(this.policies(user, groups))).map(l -> l.stream().collect(Collectors.toMap(WorkItem::getId, WorkItem::getName))).orElse(null);
    }

    protected Policy[] policies(String user, List<String> groups) {
        if (user == null) {
            return new Policy[0];
        }
        StaticIdentityProvider identity = null;
        if (user != null) {
            identity = new StaticIdentityProvider(user, groups);
        }
        return new Policy[]{SecurityPolicy.of((IdentityProvider)identity)};
    }
}

