/*
 * Copyright 2020 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kie.kogito.examples.onboarding;

import org.kie.kogito.MapInput;
import org.kie.kogito.MapInputId;
import org.kie.kogito.MapOutput;
import java.util.Map;
import java.util.HashMap;
import org.kie.kogito.MappableToModel;
import org.kie.kogito.Model;

public class SetupPayrollModelInput implements Model, MapInput, MapInputId, MapOutput, MappableToModel<SetupPayrollModel> {

    @org.kie.kogito.codegen.VariableInfo(tags = "")
    @com.fasterxml.jackson.annotation.JsonProperty(value = "taxRate")
    @javax.validation.Valid()
    private java.lang.Double taxRate;

    public java.lang.Double getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(java.lang.Double taxRate) {
        this.taxRate = taxRate;
    }

    @org.kie.kogito.codegen.VariableInfo(tags = "")
    @com.fasterxml.jackson.annotation.JsonProperty(value = "vacationDays")
    @javax.validation.Valid()
    private java.lang.Integer vacationDays;

    public java.lang.Integer getVacationDays() {
        return vacationDays;
    }

    public void setVacationDays(java.lang.Integer vacationDays) {
        this.vacationDays = vacationDays;
    }

    @org.kie.kogito.codegen.VariableInfo(tags = "")
    @com.fasterxml.jackson.annotation.JsonProperty(value = "payroll")
    @javax.validation.Valid()
    private org.kie.kogito.examples.onboarding.Payroll payroll;

    public org.kie.kogito.examples.onboarding.Payroll getPayroll() {
        return payroll;
    }

    public void setPayroll(org.kie.kogito.examples.onboarding.Payroll payroll) {
        this.payroll = payroll;
    }

    @org.kie.kogito.codegen.VariableInfo(tags = "")
    @com.fasterxml.jackson.annotation.JsonProperty(value = "employee")
    @javax.validation.Valid()
    private org.kie.kogito.examples.onboarding.Employee employee;

    public org.kie.kogito.examples.onboarding.Employee getEmployee() {
        return employee;
    }

    public void setEmployee(org.kie.kogito.examples.onboarding.Employee employee) {
        this.employee = employee;
    }

    @org.kie.kogito.codegen.VariableInfo(tags = "")
    @com.fasterxml.jackson.annotation.JsonProperty(value = "paymentDate")
    @javax.validation.Valid()
    private java.util.Date paymentDate;

    public java.util.Date getPaymentDate() {
        return paymentDate;
    }

    public void setPaymentDate(java.util.Date paymentDate) {
        this.paymentDate = paymentDate;
    }

    @Override()
    public SetupPayrollModel toModel() {
        SetupPayrollModel result = new SetupPayrollModel();
        result.setTaxRate(getTaxRate());
        result.setVacationDays(getVacationDays());
        result.setPayroll(getPayroll());
        result.setEmployee(getEmployee());
        result.setPaymentDate(getPaymentDate());
        return result;
    }
}
