/*
 * Copyright 2020 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kie.kogito.examples.onboarding;

import java.util.Map;
import java.util.HashMap;

public class SetupHRModelInput implements org.kie.kogito.Model {

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> params = new HashMap();
        params.put("manager", this.manager);
        params.put("employee", this.employee);
        params.put("department", this.department);
        return params;
    }

    @Override
    public void fromMap(Map<String, Object> params) {
        fromMap(null, params);
    }

    @Override
    public void update(Map<String, Object> params) {
        fromMap(params);
    }

    public void fromMap(String id, Map<String, Object> params) {
        this.manager = (java.lang.String) params.get("manager");
        this.employee = (org.kie.kogito.examples.onboarding.Employee) params.get("employee");
        this.department = (java.lang.String) params.get("department");
    }

    @org.kie.kogito.codegen.VariableInfo(tags = "")
    @com.fasterxml.jackson.annotation.JsonProperty(value = "manager")
    private java.lang.String manager;

    public java.lang.String getManager() {
        return manager;
    }

    public void setManager(java.lang.String manager) {
        this.manager = manager;
    }

    @org.kie.kogito.codegen.VariableInfo(tags = "")
    @com.fasterxml.jackson.annotation.JsonProperty(value = "employee")
    private org.kie.kogito.examples.onboarding.Employee employee;

    public org.kie.kogito.examples.onboarding.Employee getEmployee() {
        return employee;
    }

    public void setEmployee(org.kie.kogito.examples.onboarding.Employee employee) {
        this.employee = employee;
    }

    @org.kie.kogito.codegen.VariableInfo(tags = "")
    @com.fasterxml.jackson.annotation.JsonProperty(value = "department")
    private java.lang.String department;

    public java.lang.String getDepartment() {
        return department;
    }

    public void setDepartment(java.lang.String department) {
        this.department = department;
    }

    public SetupHRModel toModel() {
        SetupHRModel result = new SetupHRModel();
        result.setManager(getManager());
        result.setEmployee(getEmployee());
        result.setDepartment(getDepartment());
        return result;
    }
}
