/*
 * Copyright 2019 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kie.kogito.examples.onboarding;

import java.util.Map;
import org.kie.kogito.UserTask;
import org.kie.kogito.UserTaskParam.ParamType;
import org.kie.kogito.UserTaskParam;

@UserTask(taskName = "ManagerConfirmation", processName = "onboarding.onboarding")
public class Onboarding_3_TaskInput {

    private String _id;

    private String _name;

    public void setId(String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public static Onboarding_3_TaskInput from(org.kie.kogito.process.WorkItem workItem) {
        Onboarding_3_TaskInput item = new Onboarding_3_TaskInput();
        item._id = workItem.getId();
        item._name = workItem.getName();
        Map<String, Object> params = workItem.getParameters();
        item.depeartment = (java.lang.String) params.get("depeartment");
        item.employeeId = (java.lang.String) params.get("employeeId");
        item.payroll = (org.kie.kogito.examples.onboarding.Payroll) params.get("payroll");
        item.employee = (org.kie.kogito.examples.onboarding.Employee) params.get("employee");
        item.email = (java.lang.String) params.get("email");
        return item;
    }

    @UserTaskParam(value = ParamType.INPUT)
    private java.lang.String depeartment;

    public java.lang.String getDepeartment() {
        return depeartment;
    }

    public void setDepeartment(java.lang.String depeartment) {
        this.depeartment = depeartment;
    }

    @UserTaskParam(value = ParamType.INPUT)
    private java.lang.String employeeId;

    public java.lang.String getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(java.lang.String employeeId) {
        this.employeeId = employeeId;
    }

    @UserTaskParam(value = ParamType.INPUT)
    private org.kie.kogito.examples.onboarding.Payroll payroll;

    public org.kie.kogito.examples.onboarding.Payroll getPayroll() {
        return payroll;
    }

    public void setPayroll(org.kie.kogito.examples.onboarding.Payroll payroll) {
        this.payroll = payroll;
    }

    @UserTaskParam(value = ParamType.INPUT)
    private org.kie.kogito.examples.onboarding.Employee employee;

    public org.kie.kogito.examples.onboarding.Employee getEmployee() {
        return employee;
    }

    public void setEmployee(org.kie.kogito.examples.onboarding.Employee employee) {
        this.employee = employee;
    }

    @UserTaskParam(value = ParamType.INPUT)
    private java.lang.String email;

    public java.lang.String getEmail() {
        return email;
    }

    public void setEmail(java.lang.String email) {
        this.email = email;
    }
}
// Task input model for user task 'Manager confirmation' in process 'onboarding.onboarding'
