/*
 * Copyright 2019 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kie.kogito.examples.onboarding;

import java.util.HashMap;
import java.util.Map;
import org.kie.kogito.MapOutput;
import org.kie.kogito.UserTask;
import org.kie.kogito.UserTaskParam.ParamType;
import org.kie.kogito.UserTaskParam;

@UserTask(taskName = "ManagerConfirmation", processName = "onboarding.onboarding")
public class Onboarding_3_TaskOutput implements MapOutput {

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> params = new HashMap<>();
        params.put("message", this.message);
        params.put("status", this.status);
        return params;
    }

    public static Onboarding_3_TaskOutput fromMap(Map<String, Object> params) {
        org.kie.kogito.examples.onboarding.Onboarding_3_TaskOutput result = new Onboarding_3_TaskOutput();
        result.message = (java.lang.String) params.get("message");
        result.status = (java.lang.String) params.get("status");
        return result;
    }

    @UserTaskParam(value = ParamType.OUTPUT)
    private java.lang.String message;

    public java.lang.String getMessage() {
        return message;
    }

    public void setMessage(java.lang.String message) {
        this.message = message;
    }

    @UserTaskParam(value = ParamType.OUTPUT)
    private java.lang.String status;

    public java.lang.String getStatus() {
        return status;
    }

    public void setStatus(java.lang.String status) {
        this.status = status;
    }
}
// Task output for user task 'Manager confirmation' in process 'onboarding.onboarding'
