/*
 * Copyright 2020 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kie.kogito.examples.onboarding;

import org.kie.kogito.MapInput;
import org.kie.kogito.MapInputId;
import org.kie.kogito.MapOutput;
import java.util.Map;
import java.util.HashMap;
import org.kie.kogito.MappableToModel;
import org.kie.kogito.Model;

public class SetupHRModelInput implements Model, MapInput, MapInputId, MapOutput, MappableToModel<SetupHRModel> {

    @org.kie.kogito.codegen.VariableInfo(tags = "")
    @com.fasterxml.jackson.annotation.JsonProperty(value = "manager")
    @javax.validation.Valid()
    private java.lang.String manager;

    public java.lang.String getManager() {
        return manager;
    }

    public void setManager(java.lang.String manager) {
        this.manager = manager;
    }

    @org.kie.kogito.codegen.VariableInfo(tags = "")
    @com.fasterxml.jackson.annotation.JsonProperty(value = "employee")
    @javax.validation.Valid()
    private org.kie.kogito.examples.onboarding.Employee employee;

    public org.kie.kogito.examples.onboarding.Employee getEmployee() {
        return employee;
    }

    public void setEmployee(org.kie.kogito.examples.onboarding.Employee employee) {
        this.employee = employee;
    }

    @org.kie.kogito.codegen.VariableInfo(tags = "")
    @com.fasterxml.jackson.annotation.JsonProperty(value = "department")
    @javax.validation.Valid()
    private java.lang.String department;

    public java.lang.String getDepartment() {
        return department;
    }

    public void setDepartment(java.lang.String department) {
        this.department = department;
    }

    @Override()
    public SetupHRModel toModel() {
        SetupHRModel result = new SetupHRModel();
        result.setManager(getManager());
        result.setEmployee(getEmployee());
        result.setDepartment(getDepartment());
        return result;
    }
}
