package testtree.samplemine;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.pmml.commons.model.*;
import org.kie.pmml.commons.model.expressions.*;
import org.kie.pmml.commons.transformations.*;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.models.tree.model.KiePMMLTreeModel;

public class SampleMine extends KiePMMLTreeModel {

    public SampleMine() {
        super("SampleMine");
        targetField = "decision";
        pmmlMODEL = org.kie.pmml.api.enums.PMML_MODEL.TREE_MODEL;
        miningFunction = org.kie.pmml.api.enums.MINING_FUNCTION.CLASSIFICATION;
        nodeFunction = testtree.samplemine.Node9ff5d16780814146adb0f3e0f9a34643::evaluateNode;
        transformationDictionary = null;
        localTransformations = null;
        kiePMMLMiningFields = this.getCreatedKiePMMLMiningFields();
        kiePMMLOutputFields = this.getCreatedKiePMMLOutputFields();
        miningFields.add(new org.kie.pmml.api.models.MiningField("temperature", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.RETURN_INVALID, null, null, java.util.Arrays.asList(), java.util.Arrays.asList(new org.kie.pmml.api.models.Interval(null, -10), new org.kie.pmml.api.models.Interval(-10, 10), new org.kie.pmml.api.models.Interval(10, null))));
        miningFields.add(new org.kie.pmml.api.models.MiningField("humidity", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.RETURN_INVALID, null, null, java.util.Arrays.asList(), java.util.Arrays.asList(new org.kie.pmml.api.models.Interval(null, 10.5))));
        miningFields.add(new org.kie.pmml.api.models.MiningField("decision", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.PREDICTED, null, org.kie.pmml.api.enums.DATA_TYPE.STRING, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.RETURN_INVALID, null, null, java.util.Arrays.asList("sunglasses", "umbrella", "nothing"), java.util.Arrays.asList()));
        outputFields.add(new org.kie.pmml.api.models.OutputField("weatherdecision", null, org.kie.pmml.api.enums.DATA_TYPE.STRING, "decision", org.kie.pmml.api.enums.RESULT_FEATURE.PREDICTED_VALUE, java.util.Arrays.asList("sunglasses", "umbrella", "nothing")));
    }

    private List<KiePMMLMiningField> getCreatedKiePMMLMiningFields() {
        KiePMMLMiningField temperature = KiePMMLMiningField.builder("temperature", Collections.emptyList()).withFieldUsageType(org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE).withOpType(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.DOUBLE).withMissingValueTreatmentMethod(null).withInvalidValueTreatmentMethod(org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.RETURN_INVALID).withMissingValueReplacement(null).withInvalidValueReplacement(null).withAllowedValues(Arrays.asList()).withIntervals(Arrays.asList(new KiePMMLInterval(null, -10, org.kie.pmml.api.enums.CLOSURE.OPEN_CLOSED), new KiePMMLInterval(-10, 10, org.kie.pmml.api.enums.CLOSURE.CLOSED_CLOSED), new KiePMMLInterval(10, null, org.kie.pmml.api.enums.CLOSURE.CLOSED_OPEN))).build();
        KiePMMLMiningField humidity = KiePMMLMiningField.builder("humidity", Collections.emptyList()).withFieldUsageType(org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE).withOpType(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.DOUBLE).withMissingValueTreatmentMethod(null).withInvalidValueTreatmentMethod(org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.RETURN_INVALID).withMissingValueReplacement(null).withInvalidValueReplacement(null).withAllowedValues(Arrays.asList()).withIntervals(Arrays.asList(new KiePMMLInterval(null, 10.5, org.kie.pmml.api.enums.CLOSURE.OPEN_CLOSED))).build();
        KiePMMLMiningField decision = KiePMMLMiningField.builder("decision", Collections.emptyList()).withFieldUsageType(org.kie.pmml.api.enums.FIELD_USAGE_TYPE.PREDICTED).withOpType(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.STRING).withMissingValueTreatmentMethod(null).withInvalidValueTreatmentMethod(org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.RETURN_INVALID).withMissingValueReplacement(null).withInvalidValueReplacement(null).withAllowedValues(Arrays.asList("sunglasses", "umbrella", "nothing")).withIntervals(Arrays.asList()).build();
        return Arrays.asList(temperature, humidity, decision);
    }

    private List<KiePMMLOutputField> getCreatedKiePMMLOutputFields() {
        KiePMMLOutputField weatherdecision = KiePMMLOutputField.builder("weatherdecision", Collections.emptyList()).withResultFeature(org.kie.pmml.api.enums.RESULT_FEATURE.PREDICTED_VALUE).withTargetField("decision").withValue(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.STRING).withRank(1).withKiePMMLExpression(null).build();
        return Arrays.asList(weatherdecision);
    }
}
