package testtree.samplemine;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.predicates.KiePMMLCompoundPredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLFalsePredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLPredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLSimplePredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLSimpleSetPredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLTruePredicate;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.models.tree.model.KiePMMLNode;
import org.kie.pmml.models.tree.model.KiePMMLNodeResult;
import org.kie.pmml.models.tree.model.KiePMMLScoreDistribution;

public class Node01bc7f095a2642d692c2e156bd372ec8 extends KiePMMLNode {

    public Node01bc7f095a2642d692c2e156bd372ec8() {
        super("1", Collections.emptyList());
    }

    public static KiePMMLNodeResult evaluateNode(final Map<String, Object> requestData) {
        KiePMMLTruePredicate predicate = new KiePMMLTruePredicate("predicate", Collections.emptyList());
        if (!predicate.evaluate(requestData)) {
            return null;
        }
        final List<Function<Map<String, Object>, KiePMMLNodeResult>> nodeFunctions = java.util.Arrays.asList(Node01bc7f095a2642d692c2e156bd372ec8::evaluateNodeNode645165665fc74a54a1e6236340b8614f, Node01bc7f095a2642d692c2e156bd372ec8::evaluateNodeNode869d57ad22b641c2a542e0be82125667, Node01bc7f095a2642d692c2e156bd372ec8::evaluateNodeNode12f90b4dade4455eb80e34088835b9b4);
        final Object score = "nothing";
        final List<KiePMMLScoreDistribution> scoreDistributions = null;
        final double missingValuePenalty = 1.0;
        KiePMMLNodeResult kiePMMLNodeResult = new KiePMMLNodeResult(score, KiePMMLNode.getProbabilityConfidenceMap(scoreDistributions, missingValuePenalty));
        if (nodeFunctions.isEmpty()) {
            return kiePMMLNodeResult;
        }
        Optional<KiePMMLNodeResult> nestedKiePMMLNodeResult = KiePMMLNode.getNestedKiePMMLNodeResult(nodeFunctions, requestData);
        return nestedKiePMMLNodeResult.orElse(kiePMMLNodeResult);
    }

    private static KiePMMLNodeResult evaluateNodeNode645165665fc74a54a1e6236340b8614f(final Map<String, Object> requestData) {
        KiePMMLSimplePredicate predicate_0 = KiePMMLSimplePredicate.builder("temperature", Collections.emptyList(), org.kie.pmml.api.enums.OPERATOR.GREATER_THAN).withValue(25.0).build();
        KiePMMLSimplePredicate predicate_1 = KiePMMLSimplePredicate.builder("humidity", Collections.emptyList(), org.kie.pmml.api.enums.OPERATOR.LESS_OR_EQUAL).withValue(20.0).build();
        KiePMMLCompoundPredicate predicate = KiePMMLCompoundPredicate.builder(Collections.emptyList(), org.kie.pmml.api.enums.BOOLEAN_OPERATOR.AND).withKiePMMLPredicates(Arrays.asList(predicate_0, predicate_1)).build();
        if (!predicate.evaluate(requestData)) {
            return null;
        }
        final List<Function<Map<String, Object>, KiePMMLNodeResult>> nodeFunctions = java.util.Collections.emptyList();
        final Object score = "sunglasses";
        final List<KiePMMLScoreDistribution> scoreDistributions = null;
        final double missingValuePenalty = 1.0;
        KiePMMLNodeResult kiePMMLNodeResult = new KiePMMLNodeResult(score, KiePMMLNode.getProbabilityConfidenceMap(scoreDistributions, missingValuePenalty));
        if (nodeFunctions.isEmpty()) {
            return kiePMMLNodeResult;
        }
        Optional<KiePMMLNodeResult> nestedKiePMMLNodeResult = KiePMMLNode.getNestedKiePMMLNodeResult(nodeFunctions, requestData);
        return nestedKiePMMLNodeResult.orElse(kiePMMLNodeResult);
    }

    private static KiePMMLNodeResult evaluateNodeNode869d57ad22b641c2a542e0be82125667(final Map<String, Object> requestData) {
        KiePMMLSimplePredicate predicate = KiePMMLSimplePredicate.builder("humidity", Collections.emptyList(), org.kie.pmml.api.enums.OPERATOR.GREATER_THAN).withValue(50.0).build();
        if (!predicate.evaluate(requestData)) {
            return null;
        }
        final List<Function<Map<String, Object>, KiePMMLNodeResult>> nodeFunctions = java.util.Collections.emptyList();
        final Object score = "umbrella";
        final List<KiePMMLScoreDistribution> scoreDistributions = null;
        final double missingValuePenalty = 1.0;
        KiePMMLNodeResult kiePMMLNodeResult = new KiePMMLNodeResult(score, KiePMMLNode.getProbabilityConfidenceMap(scoreDistributions, missingValuePenalty));
        if (nodeFunctions.isEmpty()) {
            return kiePMMLNodeResult;
        }
        Optional<KiePMMLNodeResult> nestedKiePMMLNodeResult = KiePMMLNode.getNestedKiePMMLNodeResult(nodeFunctions, requestData);
        return nestedKiePMMLNodeResult.orElse(kiePMMLNodeResult);
    }

    private static KiePMMLNodeResult evaluateNodeNode12f90b4dade4455eb80e34088835b9b4(final Map<String, Object> requestData) {
        KiePMMLTruePredicate predicate = new KiePMMLTruePredicate("predicate", Collections.emptyList());
        if (!predicate.evaluate(requestData)) {
            return null;
        }
        final List<Function<Map<String, Object>, KiePMMLNodeResult>> nodeFunctions = java.util.Collections.emptyList();
        final Object score = "nothing";
        final List<KiePMMLScoreDistribution> scoreDistributions = null;
        final double missingValuePenalty = 1.0;
        KiePMMLNodeResult kiePMMLNodeResult = new KiePMMLNodeResult(score, KiePMMLNode.getProbabilityConfidenceMap(scoreDistributions, missingValuePenalty));
        if (nodeFunctions.isEmpty()) {
            return kiePMMLNodeResult;
        }
        Optional<KiePMMLNodeResult> nestedKiePMMLNodeResult = KiePMMLNode.getNestedKiePMMLNodeResult(nodeFunctions, requestData);
        return nestedKiePMMLNodeResult.orElse(kiePMMLNodeResult);
    }
}
