/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.traffic;

import io.vertx.mutiny.core.Vertx;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.kie.kogito.traffic.Driver;
import org.kie.kogito.traffic.TrafficViolationResponse;
import org.kie.kogito.traffic.Violation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class TrafficViolationRestService {
    private final URI uri;

    @Bean
    public Vertx vertx() {
        return Vertx.vertx();
    }

    public TrafficViolationRestService() {
        this.uri = null;
    }

    @Autowired
    public TrafficViolationRestService(@Value(value="${traffic.violation.url}") String url) {
        this.uri = UriComponentsBuilder.fromUriString((String)url).path("/Traffic Violation").build().toUri();
    }

    public TrafficViolationResponse evaluate(Driver driver, Violation violation) {
        return (TrafficViolationResponse)new RestTemplateBuilder(new RestTemplateCustomizer[0]).build().postForObject(this.uri, (Object)this.toMap(driver, violation), TrafficViolationResponse.class);
    }

    public Map<String, Object> toMap(Driver driver, Violation violation) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("Violation", violation);
        params.put("Driver", driver);
        return params;
    }
}

