package com.example;

import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.ruleflow.core.RuleFlowProcessFactory;
import org.drools.core.util.KieFunctions;

@org.springframework.stereotype.Component("traffic_wih")
public class Traffic_wihProcess extends org.kie.kogito.process.impl.AbstractProcess<com.example.Traffic_wihModel> {

    public Traffic_wihProcess(org.kie.kogito.app.Application app) {
        this(app, new org.kie.kogito.handlers.traffic_wihRestWorkItemHandler(), new org.kie.kogito.handlers.DriverService_getDriver_5_Handler());
    }

    @org.springframework.beans.factory.annotation.Autowired()
    public Traffic_wihProcess(org.kie.kogito.app.Application app, org.kie.kogito.handlers.traffic_wihRestWorkItemHandler traffic_wihRestWorkItemHandler, org.kie.kogito.handlers.DriverService_getDriver_5_Handler driverService_getDriver_5_Handler) {
        super(app, java.util.Arrays.asList(traffic_wihRestWorkItemHandler, driverService_getDriver_5_Handler));
        activate();
    }

    public Traffic_wihProcess() {
    }

    @Override()
    public com.example.Traffic_wihProcessInstance createInstance(com.example.Traffic_wihModel value) {
        return new com.example.Traffic_wihProcessInstance(this, value, this.createProcessRuntime());
    }

    public com.example.Traffic_wihProcessInstance createInstance(java.lang.String businessKey, com.example.Traffic_wihModel value) {
        return new com.example.Traffic_wihProcessInstance(this, value, businessKey, this.createProcessRuntime());
    }

    @Override()
    public com.example.Traffic_wihModel createModel() {
        return new com.example.Traffic_wihModel();
    }

    public com.example.Traffic_wihProcessInstance createInstance(org.kie.kogito.Model value) {
        return this.createInstance((com.example.Traffic_wihModel) value);
    }

    public com.example.Traffic_wihProcessInstance createInstance(java.lang.String businessKey, org.kie.kogito.Model value) {
        return this.createInstance(businessKey, (com.example.Traffic_wihModel) value);
    }

    public com.example.Traffic_wihProcessInstance createInstance(org.kie.api.runtime.process.WorkflowProcessInstance wpi) {
        return new com.example.Traffic_wihProcessInstance(this, this.createModel(), this.createProcessRuntime(), wpi);
    }

    public com.example.Traffic_wihProcessInstance createReadOnlyInstance(org.kie.api.runtime.process.WorkflowProcessInstance wpi) {
        return new com.example.Traffic_wihProcessInstance(this, this.createModel(), wpi);
    }

    public org.kie.api.definition.process.Process process() {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess("traffic_wih");
        factory.variable("driverId", new ObjectDataType("java.lang.String", com.example.Traffic_wihProcess.class.getClassLoader()), "customTags", null);
        factory.variable("violation", new ObjectDataType("org.kie.kogito.traffic.Violation", com.example.Traffic_wihProcess.class.getClassLoader()), "customTags", null);
        factory.variable("driver", new ObjectDataType("org.kie.kogito.traffic.Driver", com.example.Traffic_wihProcess.class.getClassLoader()), "customTags", null);
        factory.variable("trafficViolationResponse", new ObjectDataType("org.kie.kogito.traffic.TrafficViolationResponse", com.example.Traffic_wihProcess.class.getClassLoader()), "customTags", null);
        factory.name("traffic_wih");
        factory.packageName("com.example");
        factory.dynamic(false);
        factory.version("1.0");
        factory.visibility("Public");
        factory.metaData("TargetNamespace", "http://www.omg.org/bpmn20");
        org.jbpm.ruleflow.core.factory.WorkItemNodeFactory<?> workItemNode1 = factory.workItemNode(1);
        workItemNode1.name("TrafficViolation\nDMN");
        workItemNode1.workName("traffic_wihRestWorkItemHandler");
        workItemNode1.workParameter("Method", "POST");
        workItemNode1.workParameter("Url", "http://localhost:8080/Traffic Violation");
        workItemNode1.workParameter("TaskName", "Rest");
        workItemNode1.inMapping("Violation", "violation");
        workItemNode1.inMapping("Driver", "driver");
        workItemNode1.outMapping("Result", "trafficViolationResponse");
        workItemNode1.done();
        workItemNode1.metaData("UniqueId", "_38F4877F-50AD-4500-98E1-9B4FD3972291");
        workItemNode1.metaData("elementname", "TrafficViolation\nDMN");
        workItemNode1.metaData("x", 867);
        workItemNode1.metaData("width", 154);
        workItemNode1.metaData("y", 204);
        workItemNode1.metaData("height", 102);
        org.jbpm.ruleflow.core.factory.WorkItemNodeFactory<?> workItemNode2 = factory.workItemNode(2);
        workItemNode2.name("LicenseValidation\nDRL");
        workItemNode2.workName("traffic_wihRestWorkItemHandler");
        workItemNode2.workParameter("Method", "POST");
        workItemNode2.workParameter("Url", "http://localhost:8080/validation/first");
        workItemNode2.workParameter("test", 1);
        workItemNode2.workParameter("TaskName", "Rest");
        workItemNode2.inMapping("driver", "driver");
        workItemNode2.outMapping("Result", "driver");
        workItemNode2.done();
        workItemNode2.metaData("UniqueId", "_D8D9E6BA-5940-41F5-BF3A-1A08ADA72A4C");
        workItemNode2.metaData("elementname", "LicenseValidation\nDRL");
        workItemNode2.metaData("x", 423);
        workItemNode2.metaData("width", 170);
        workItemNode2.metaData("y", 205);
        workItemNode2.metaData("height", 105);
        org.jbpm.ruleflow.core.factory.EndNodeFactory<?> endNode3 = factory.endNode(3);
        endNode3.name("End");
        endNode3.terminate(false);
        endNode3.metaData("UniqueId", "_E2A8304B-68A0-4CCC-8D47-1FA9352D4853");
        endNode3.metaData("x", 813);
        endNode3.metaData("width", 56);
        endNode3.metaData("y", 408);
        endNode3.metaData("height", 56);
        endNode3.done();
        org.jbpm.ruleflow.core.factory.SplitFactory<?> splitNode4 = factory.splitNode(4);
        splitNode4.name("Split");
        splitNode4.type(2);
        splitNode4.metaData("UniqueId", "_7229480F-BC4D-4406-B27C-8FF46C5C9042");
        splitNode4.metaData("x", 637);
        splitNode4.metaData("width", 56);
        splitNode4.metaData("y", 227);
        splitNode4.metaData("height", 56);
        splitNode4.constraint(1, "_8A36870E-651D-4E0A-B345-D5CFF2182F0F", "DROOLS_DEFAULT", "java", kcontext -> {
            java.lang.String driverId = (java.lang.String) kcontext.getVariable("driverId");
            org.kie.kogito.traffic.Violation violation = (org.kie.kogito.traffic.Violation) kcontext.getVariable("violation");
            org.kie.kogito.traffic.Driver driver = (org.kie.kogito.traffic.Driver) kcontext.getVariable("driver");
            org.kie.kogito.traffic.TrafficViolationResponse trafficViolationResponse = (org.kie.kogito.traffic.TrafficViolationResponse) kcontext.getVariable("trafficViolationResponse");
            return driver.isValidLicense();
        }, 0);
        splitNode4.constraint(3, "_044AA388-325A-45DE-B783-4F48421B788B", "DROOLS_DEFAULT", "java", kcontext -> {
            java.lang.String driverId = (java.lang.String) kcontext.getVariable("driverId");
            org.kie.kogito.traffic.Violation violation = (org.kie.kogito.traffic.Violation) kcontext.getVariable("violation");
            org.kie.kogito.traffic.Driver driver = (org.kie.kogito.traffic.Driver) kcontext.getVariable("driver");
            org.kie.kogito.traffic.TrafficViolationResponse trafficViolationResponse = (org.kie.kogito.traffic.TrafficViolationResponse) kcontext.getVariable("trafficViolationResponse");
            return !driver.isValidLicense();
        }, 0);
        splitNode4.done();
        org.jbpm.ruleflow.core.factory.WorkItemNodeFactory<?> workItemNode5 = factory.workItemNode(5);
        workItemNode5.name("Get Driver Details");
        workItemNode5.workName("org.kie.kogito.traffic.DriverService_getDriver_5_Handler");
        workItemNode5.workParameter("Interface", "org.kie.kogito.traffic.DriverService");
        workItemNode5.workParameter("Operation", "getDriver");
        workItemNode5.workParameter("interfaceImplementationRef", "org.kie.kogito.traffic.DriverService");
        workItemNode5.workParameter("operationImplementationRef", "getDriver");
        workItemNode5.workParameter("implementation", "Java");
        workItemNode5.inMapping("driverId", "driverId");
        workItemNode5.outMapping("response", "driver");
        workItemNode5.done();
        workItemNode5.metaData("UniqueId", "_93FFD317-476E-4624-84EF-994617572560");
        workItemNode5.metaData("Implementation", "Java");
        workItemNode5.metaData("elementname", "Get Driver Details");
        workItemNode5.metaData("Type", "Service Task");
        workItemNode5.metaData("OperationRef", "_93FFD317-476E-4624-84EF-994617572560_ServiceOperation");
        workItemNode5.metaData("x", 195);
        workItemNode5.metaData("width", 154);
        workItemNode5.metaData("y", 205);
        workItemNode5.metaData("height", 102);
        org.jbpm.ruleflow.core.factory.EndNodeFactory<?> endNode6 = factory.endNode(6);
        endNode6.name("End");
        endNode6.terminate(false);
        endNode6.metaData("UniqueId", "_67972C63-8A06-42C5-A3FF-A843EFB4D07B");
        endNode6.metaData("x", 1438);
        endNode6.metaData("width", 56);
        endNode6.metaData("y", 100);
        endNode6.metaData("height", 56);
        endNode6.done();
        org.jbpm.ruleflow.core.factory.ActionNodeFactory<?> actionNode7 = factory.actionNode(7);
        actionNode7.name("Suspended\nTask");
        actionNode7.action(kcontext -> {
            System.out.println("Driver is suspended!");
        });
        actionNode7.metaData("UniqueId", "_298312AB-7A3D-478B-BD9B-B260CE847645");
        actionNode7.metaData("elementname", "Suspended\nTask");
        actionNode7.metaData("NodeType", "ScriptTask");
        actionNode7.metaData("x", 1194);
        actionNode7.metaData("width", 178);
        actionNode7.metaData("y", 77);
        actionNode7.metaData("height", 102);
        actionNode7.done();
        org.jbpm.ruleflow.core.factory.SplitFactory<?> splitNode8 = factory.splitNode(8);
        splitNode8.name("Split");
        splitNode8.type(2);
        splitNode8.metaData("UniqueId", "_8A66FABC-E538-4F50-9DAC-BC9069D19942");
        splitNode8.metaData("x", 1078);
        splitNode8.metaData("width", 56);
        splitNode8.metaData("y", 225);
        splitNode8.metaData("Default", "_19CC68B6-D2DC-4E39-99E5-CE5B30C5FEE6");
        splitNode8.metaData("height", 56);
        splitNode8.constraint(10, "_19CC68B6-D2DC-4E39-99E5-CE5B30C5FEE6", "DROOLS_DEFAULT", "java", kcontext -> {
            java.lang.String driverId = (java.lang.String) kcontext.getVariable("driverId");
            org.kie.kogito.traffic.Violation violation = (org.kie.kogito.traffic.Violation) kcontext.getVariable("violation");
            org.kie.kogito.traffic.Driver driver = (org.kie.kogito.traffic.Driver) kcontext.getVariable("driver");
            org.kie.kogito.traffic.TrafficViolationResponse trafficViolationResponse = (org.kie.kogito.traffic.TrafficViolationResponse) kcontext.getVariable("trafficViolationResponse");
            return !trafficViolationResponse.isSuspended();
        }, 0);
        splitNode8.constraint(7, "_249EB7E9-5847-47C9-8B4D-8BEFED257600", "DROOLS_DEFAULT", "java", kcontext -> {
            java.lang.String driverId = (java.lang.String) kcontext.getVariable("driverId");
            org.kie.kogito.traffic.Violation violation = (org.kie.kogito.traffic.Violation) kcontext.getVariable("violation");
            org.kie.kogito.traffic.Driver driver = (org.kie.kogito.traffic.Driver) kcontext.getVariable("driver");
            org.kie.kogito.traffic.TrafficViolationResponse trafficViolationResponse = (org.kie.kogito.traffic.TrafficViolationResponse) kcontext.getVariable("trafficViolationResponse");
            return trafficViolationResponse.isSuspended();
        }, 0);
        splitNode8.done();
        org.jbpm.ruleflow.core.factory.EndNodeFactory<?> endNode9 = factory.endNode(9);
        endNode9.name("End");
        endNode9.terminate(false);
        endNode9.metaData("UniqueId", "_418CD980-670D-4FC5-B492-A271A61B1477");
        endNode9.metaData("x", 1445);
        endNode9.metaData("width", 56);
        endNode9.metaData("y", 377);
        endNode9.metaData("height", 56);
        endNode9.done();
        org.jbpm.ruleflow.core.factory.ActionNodeFactory<?> actionNode10 = factory.actionNode(10);
        actionNode10.name("Not Suspended\n Task");
        actionNode10.action(kcontext -> {
            System.out.println("Driver is NOT suspended!");
        });
        actionNode10.metaData("UniqueId", "_DDD02AFB-D927-47BC-9C0C-523B602B5CD2");
        actionNode10.metaData("elementname", "Not Suspended\n Task");
        actionNode10.metaData("NodeType", "ScriptTask");
        actionNode10.metaData("x", 1203);
        actionNode10.metaData("width", 181);
        actionNode10.metaData("y", 355);
        actionNode10.metaData("height", 100);
        actionNode10.done();
        org.jbpm.ruleflow.core.factory.StartNodeFactory<?> startNode11 = factory.startNode(11);
        startNode11.name("Start");
        startNode11.interrupting(true);
        startNode11.metaData("UniqueId", "_905F0834-19CC-423B-B90E-B38C6D80329F");
        startNode11.metaData("x", 79);
        startNode11.metaData("width", 56);
        startNode11.metaData("y", 227);
        startNode11.metaData("height", 56);
        startNode11.done();
        factory.connection(4, 1, "_8A36870E-651D-4E0A-B345-D5CFF2182F0F");
        factory.connection(5, 2, "_A19108FE-08A2-4E80-B7A8-0254C49209A6");
        factory.connection(4, 3, "_044AA388-325A-45DE-B783-4F48421B788B");
        factory.connection(2, 4, "_53D4F783-4C4F-45F7-A73B-25A582C41A09");
        factory.connection(11, 5, "_2C2FFD79-4241-4F9E-A486-2482F817595E");
        factory.connection(7, 6, "_1287C97D-3568-458A-A907-0123A64A93BE");
        factory.connection(8, 7, "_249EB7E9-5847-47C9-8B4D-8BEFED257600");
        factory.connection(1, 8, "_4C002D81-1A8E-4D60-A740-9630D94215EB");
        factory.connection(10, 9, "_521A00FC-6A79-44ED-8485-45DB97A621F2");
        factory.connection(8, 10, "_19CC68B6-D2DC-4E39-99E5-CE5B30C5FEE6");
        factory.validate();
        return factory.getProcess();
    }
}
