/*
 * Copyright 2021 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kie.kogito.test;

import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.kie.kogito.Application;
import org.kie.kogito.conf.ConfigBean;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessService;
import org.kie.kogito.services.event.impl.AbstractMessageConsumer;
import org.kie.kogito.event.EventUnmarshaller;
import org.kie.kogito.event.EventReceiver;
import org.kie.kogito.event.KogitoEventExecutor;

@org.springframework.stereotype.Component()
public class TravelersMessageConsumer_4 extends AbstractMessageConsumer<TravelersModel, org.acme.travel.Traveller> {

    @org.springframework.beans.factory.annotation.Autowired
    ObjectMapper objectMapper;

    @org.springframework.beans.factory.annotation.Autowired
    TravelersMessageConsumer_4(Application application, @org.springframework.beans.factory.annotation.Qualifier("Travelers") Process<TravelersModel> process, ConfigBean configBean, EventReceiver eventReceiver, ProcessService processService, @org.springframework.beans.factory.annotation.Qualifier(KogitoEventExecutor.BEAN_NAME) ExecutorService executorService, EventUnmarshaller<Object> eventUnmarshaller) {
        super(application, process, "travellers", eventReceiver, org.acme.travel.Traveller.class, configBean.useCloudEvents(), processService, executorService, eventUnmarshaller);
    }

    private TravelersModel eventToModel(Object event) {
        TravelersModel model = new TravelersModel();
        if (event != null) {
            model.setTraveller(objectMapper.convertValue(event, org.acme.travel.Traveller.class));
        }
        return model;
    }

    @Override()
    protected Optional<Function<Object, TravelersModel>> getModelConverter() {
        return Optional.of(this::eventToModel);
    }
}
