/*
 * Decompiled with CFR 0.152.
 */
package org.acme.deals;

import io.quarkus.runtime.Startup;
import io.smallrye.common.annotation.Identifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Startup
public class Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(Application.class);
    @Inject
    @Identifier(value="default-kafka-broker")
    Map<String, Object> kafkaConfig;

    @PostConstruct
    public void init() throws Exception {
        try (AdminClient client = AdminClient.create(this.kafkaConfig);){
            Set topics = (Set)client.listTopics().names().get(1L, TimeUnit.MINUTES);
            List newTopics = Arrays.asList("kogito.process.dealreviews", "kogito.process.deals").stream().filter(t -> !topics.contains(t)).map(t -> new NewTopic(t, 1, 1)).collect(Collectors.toList());
            if (!newTopics.isEmpty()) {
                client.createTopics(newTopics).all().get(1L, TimeUnit.MINUTES);
                LOGGER.info("Created kogito.process.dealreviews and kogito.process.deals topics in Kafka");
            }
        }
    }
}

