/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.examples.DefaultWorkItem;
import org.kie.kogito.examples.domain.FlightDTO;
import org.kie.kogito.examples.domain.Passenger;
import org.kie.kogito.examples.domain.PassengerDTO;
import org.kie.kogito.process.WorkItem;

@QuarkusTest
public class FlightTest {
    @Test
    public void testFlightsProcess() throws JsonProcessingException {
        ObjectMapper jsonMapper = new ObjectMapper();
        FlightDTO flightParams = new FlightDTO();
        flightParams.setDepartureDateTime(LocalDateTime.now().toString());
        flightParams.setDestination("B");
        flightParams.setOrigin("A");
        flightParams.setSeatColumnSize(10);
        flightParams.setSeatRowSize(6);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("params", flightParams);
        String id = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(jsonMapper.writeValueAsString(parameters)).contentType(ContentType.JSON).when().post("/rest/flights", new Object[0])).then()).statusCode(201)).body("params.departureDateTime", Matchers.is((Object)flightParams.getDepartureDateTime()), new Object[0])).body("params.origin", Matchers.is((Object)flightParams.getOrigin()), new Object[0])).body("params.destination", Matchers.is((Object)flightParams.getDestination()), new Object[0])).body("params.seatRowSize", Matchers.is((Object)flightParams.getSeatRowSize()), new Object[0])).body("params.seatColumnSize", Matchers.is((Object)flightParams.getSeatColumnSize()), new Object[0])).extract().body().path("id", new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/rest/flights", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)id), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/rest/flights/" + id, new Object[0])).then()).statusCode(200)).body("params.departureDateTime", Matchers.is((Object)flightParams.getDepartureDateTime()), new Object[0])).body("params.origin", Matchers.is((Object)flightParams.getOrigin()), new Object[0])).body("params.destination", Matchers.is((Object)flightParams.getDestination()), new Object[0])).body("params.seatRowSize", Matchers.is((Object)flightParams.getSeatRowSize()), new Object[0])).body("params.seatColumnSize", Matchers.is((Object)flightParams.getSeatColumnSize()), new Object[0]);
        PassengerDTO passengerDTO = new PassengerDTO("john", "WINDOW", false, false, null);
        ((ValidatableResponse)((Response)RestAssured.given().body(jsonMapper.writeValueAsString((Object)passengerDTO)).contentType(ContentType.JSON).when().post("/rest/flights/" + id + "/newPassengerRequest", new Object[0])).then()).statusCode(200);
        WorkItem[] tasks = (WorkItem[])((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/rest/flights/" + id + "/tasks", new Object[0])).then()).statusCode(200)).body("$.size", Matchers.is((Object)2), new Object[0])).extract().as(DefaultWorkItem[].class);
        String denyId = this.findIdByName(tasks, "approveDenyPassenger");
        Assertions.assertNotNull((Object)denyId, (String)"returned task does not contain approveDenyPassenger");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/rest/flights/" + id + "/approveDenyPassenger/" + denyId, new Object[0])).then()).statusCode(200)).body("parameters.passenger.name", Matchers.is((Object)passengerDTO.getName()), new Object[0]);
        parameters = new HashMap();
        parameters.put("isPassengerApproved", true);
        ((ValidatableResponse)((Response)RestAssured.given().body(jsonMapper.writeValueAsString(parameters)).contentType(ContentType.JSON).when().post("/rest/flights/" + id + "/approveDenyPassenger/" + denyId, new Object[0])).then()).statusCode(200);
        String finalizeId = this.findIdByName(tasks, "finalizePassengerList");
        Assertions.assertNotNull((Object)denyId, (String)"returned task does not contain finalizePassengerList");
        parameters = new HashMap();
        parameters.put("isPassengerListFinalized", true);
        ((ValidatableResponse)((Response)RestAssured.given().body(jsonMapper.writeValueAsString(parameters)).contentType(ContentType.JSON).when().post("/rest/flights/" + id + "/finalizePassengerList/" + finalizeId, new Object[0])).then()).statusCode(200);
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String taskId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/rest/flights/" + id + "/tasks", new Object[0])).then()).statusCode(200)).body("$.size", Matchers.is((Object)1), new Object[0])).body("[0].name", Matchers.is((Object)"finalizeSeatAssignment"), new Object[0])).extract().path("[0].id", new String[0]);
        List passengerList = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/rest/flights/" + id, new Object[0])).then()).statusCode(200)).extract().body().jsonPath().getList("flight.passengerList", Passenger.class);
        Assertions.assertNotNull((Object)((Passenger)passengerList.get(0)).getSeat());
        parameters = new HashMap();
        ((ValidatableResponse)((Response)RestAssured.given().body(jsonMapper.writeValueAsString(parameters)).contentType(ContentType.JSON).when().post("/rest/flights/" + id + "/finalizeSeatAssignment/" + taskId, new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/rest/flights", new Object[0])).then()).statusCode(200)).body("", Matchers.hasSize((int)0), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/rest/flights/" + id, new Object[0])).then()).statusCode(404);
    }

    private String findIdByName(WorkItem[] tasks, String taskName) {
        for (WorkItem task : tasks) {
            if (!taskName.equals(task.getName())) continue;
            return task.getId();
        }
        return null;
    }
}

