/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples.solver;

import java.awt.geom.Point2D;
import org.kie.kogito.examples.domain.FlightInfo;
import org.kie.kogito.examples.domain.Passenger;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;

public class FlightSeatingConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory factory) {
        return new Constraint[]{this.seatConflict(factory), this.emergencyExitRow(factory), this.seatTypePreference(factory), this.planeBalance(factory)};
    }

    private Constraint seatConflict(ConstraintFactory factory) {
        return factory.fromUniquePair(Passenger.class, Joiners.equal(Passenger::getSeat)).penalize("Seat conflict", (Score)HardSoftScore.ONE_HARD);
    }

    private Constraint emergencyExitRow(ConstraintFactory factory) {
        return factory.from(Passenger.class).filter(passenger -> passenger.getSeat().isEmergencyExitRow() && !passenger.isEmergencyExitRowCapable()).penalize("Emergency exit row has incapable passenger", (Score)HardSoftScore.ONE_HARD);
    }

    private Constraint seatTypePreference(ConstraintFactory factory) {
        return factory.from(Passenger.class).filter(passenger -> passenger.getSeat().getSeatType().violatesPreference(passenger.getSeatTypePreference())).penalize("Seat type preference", (Score)HardSoftScore.ONE_SOFT);
    }

    private Constraint planeBalance(ConstraintFactory factory) {
        return factory.from(Passenger.class).groupBy(ConstraintCollectors.sum(p -> p.getSeat().getColumn())).join(factory.from(Passenger.class).groupBy(ConstraintCollectors.sum(p -> p.getSeat().getRow()))).join(factory.from(Passenger.class).groupBy(ConstraintCollectors.count())).join(FlightInfo.class).penalize("Plane Balance", (Score)HardSoftScore.ONE_SOFT, (totalX, totalY, passengerCount, flightInfo) -> {
            double localTotalX = (double)totalX.intValue() - (double)passengerCount.intValue() * ((double)flightInfo.getSeatColumnSize() / 2.0 - 0.5);
            double localTotalY = (double)totalY.intValue() - (double)passengerCount.intValue() * ((double)flightInfo.getSeatRowSize() / 2.0 - 0.5);
            double averageX = localTotalX / (double)passengerCount.intValue();
            double averageY = localTotalY / (double)passengerCount.intValue();
            return (int)Math.round(Point2D.distance(0.0, 0.0, averageX, averageY) * (double)passengerCount.intValue() * 100.0);
        });
    }
}

