/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.kogito.Addons;
import org.kie.kogito.Config;
import org.kie.kogito.decision.DecisionConfig;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.ProcessEventListenerConfig;
import org.kie.kogito.process.WorkItemHandlerConfig;
import org.kie.kogito.process.impl.CachedProcessEventListenerConfig;
import org.kie.kogito.process.impl.DefaultWorkItemHandlerConfig;
import org.kie.kogito.process.impl.StaticProcessConfig;
import org.kie.kogito.rules.RuleConfig;
import org.kie.kogito.services.uow.CollectingUnitOfWorkFactory;
import org.kie.kogito.services.uow.DefaultUnitOfWorkManager;
import org.kie.kogito.uow.UnitOfWorkFactory;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ApplicationConfig
implements Config {
    protected ProcessConfig processConfig;
    protected RuleConfig ruleConfig;
    protected DecisionConfig decisionConfig;
    private WorkItemHandlerConfig defaultWorkItemHandlerConfig = new DefaultWorkItemHandlerConfig();
    private UnitOfWorkManager defaultUnitOfWorkManager = new DefaultUnitOfWorkManager((UnitOfWorkFactory)new CollectingUnitOfWorkFactory());
    private JobsService defaultJobsService = null;
    @Autowired
    Optional<WorkItemHandlerConfig> workItemHandlerConfig;
    @Autowired
    Optional<UnitOfWorkManager> unitOfWorkManager;
    @Autowired
    Optional<JobsService> jobsService;
    @Autowired(required=false)
    Collection<ProcessEventListenerConfig> processEventListenerConfigs;
    @Autowired(required=false)
    Collection<ProcessEventListener> processEventListeners;

    public ProcessConfig process() {
        return this.processConfig;
    }

    public RuleConfig rule() {
        return this.ruleConfig;
    }

    public DecisionConfig decision() {
        return this.decisionConfig;
    }

    private static <C, L> List<L> merge(Collection<C> configs, Function<C, Collection<L>> configToListeners, Collection<L> listeners) {
        return Stream.concat(configs.stream().flatMap(c -> ((Collection)configToListeners.apply(c)).stream()), listeners.stream()).collect(Collectors.toList());
    }

    protected WorkItemHandlerConfig extract_workItemHandlerConfig() {
        if (this.workItemHandlerConfig.isPresent()) {
            return (WorkItemHandlerConfig)this.workItemHandlerConfig.get();
        }
        return this.defaultWorkItemHandlerConfig;
    }

    protected UnitOfWorkManager extract_unitOfWorkManager() {
        if (this.unitOfWorkManager.isPresent()) {
            return (UnitOfWorkManager)this.unitOfWorkManager.get();
        }
        return this.defaultUnitOfWorkManager;
    }

    protected JobsService extract_jobsService() {
        if (this.jobsService.isPresent()) {
            return (JobsService)this.jobsService.get();
        }
        return this.defaultJobsService;
    }

    private ProcessEventListenerConfig extract_processEventListenerConfig() {
        return this.merge_processEventListenerConfig(this.processEventListenerConfigs != null ? this.processEventListenerConfigs : Collections.emptyList(), this.processEventListeners != null ? this.processEventListeners : Collections.emptyList());
    }

    private ProcessEventListenerConfig merge_processEventListenerConfig(Collection<ProcessEventListenerConfig> processEventListenerConfigs, Collection<ProcessEventListener> processEventListeners) {
        return new CachedProcessEventListenerConfig(ApplicationConfig.merge(processEventListenerConfigs, ProcessEventListenerConfig::listeners, processEventListeners));
    }

    public Addons addons() {
        return new Addons(Arrays.asList(new String[0]));
    }

    @PostConstruct
    public void init() {
        this.processConfig = new StaticProcessConfig(this.extract_workItemHandlerConfig(), this.extract_processEventListenerConfig(), this.extract_unitOfWorkManager(), this.extract_jobsService());
        this.ruleConfig = null;
        this.decisionConfig = null;
    }
}

