/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.jbpm.process.instance.impl.humantask.HumanTaskTransition;
import org.jbpm.util.JsonSchemaUtil;
import org.kie.kogito.Application;
import org.kie.kogito.MapOutput;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.examples.FlightsModel;
import org.kie.kogito.examples.FlightsModelInput;
import org.kie.kogito.examples.FlightsModelOutput;
import org.kie.kogito.examples.Flights_18_TaskInput;
import org.kie.kogito.examples.Flights_18_TaskOutput;
import org.kie.kogito.examples.Flights_6_TaskInput;
import org.kie.kogito.examples.Flights_6_TaskOutput;
import org.kie.kogito.examples.Flights_7_TaskInput;
import org.kie.kogito.examples.Flights_7_TaskOutput;
import org.kie.kogito.examples.domain.Flight;
import org.kie.kogito.examples.domain.PassengerDTO;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.impl.Sig;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.Transition;
import org.kie.kogito.services.identity.StaticIdentityProvider;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Path(value="/flights")
@Component
public class FlightsResource {
    @Autowired
    @Qualifier(value="flights")
    Process<FlightsModel> process;
    @Autowired
    Application application;

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public FlightsModelOutput createResource_flights(@Context HttpHeaders httpHeaders, @QueryParam(value="businessKey") String businessKey, @Valid @NotNull FlightsModelInput resource) {
        return (FlightsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            FlightsModelInput inputModel = resource != null ? resource : new FlightsModelInput();
            ProcessInstance pi = this.process.createInstance(businessKey, (Object)inputModel.toModel());
            String startFromNode = httpHeaders.getHeaderString("X-KOGITO-StartFromNode");
            if (startFromNode != null) {
                pi.startFrom(startFromNode);
            } else {
                pi.start();
            }
            return ((FlightsModel)pi.checkError().variables()).toOutput();
        });
    }

    @GET
    @Produces(value={"application/json"})
    public List<FlightsModelOutput> getResources_flights() {
        return this.process.instances().values().stream().map(pi -> ((FlightsModel)pi.variables()).toOutput()).collect(Collectors.toList());
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public FlightsModelOutput getResource_flights(@PathParam(value="id") String id) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> ((FlightsModel)pi.variables()).toOutput()).orElse(null);
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public FlightsModelOutput deleteResource_flights(@PathParam(value="id") String id) {
        return (FlightsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.abort();
            return ((FlightsModel)pi.checkError().variables()).toOutput();
        }).orElse(null));
    }

    @POST
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public FlightsModelOutput updateModel_flights(@PathParam(value="id") String id, FlightsModel resource) {
        return (FlightsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> ((FlightsModel)pi.updateVariables((Object)resource)).toOutput()).orElse(null));
    }

    @GET
    @Path(value="/{id}/tasks")
    @Produces(value={"application/json"})
    public Map<String, String> getTasks_flights(@PathParam(value="id") String id, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> pi.workItems(this.policies(user, groups))).map(l -> l.stream().collect(Collectors.toMap(WorkItem::getId, WorkItem::getName))).orElse(null);
    }

    protected Policy[] policies(String user, List<String> groups) {
        if (user == null) {
            return new Policy[0];
        }
        StaticIdentityProvider identity = null;
        if (user != null) {
            identity = new StaticIdentityProvider(user, groups);
        }
        return new Policy[]{SecurityPolicy.of((IdentityProvider)identity)};
    }

    @POST
    @Path(value="/{id}/solvingTerminated")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public FlightsModelOutput signal_0(@PathParam(value="id") String id, Flight data) {
        return (FlightsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.send(Sig.of((String)"solvingTerminated", (Object)data));
            return ((FlightsModel)pi.checkError().variables()).toOutput();
        }).orElse(null));
    }

    @POST
    @Path(value="/{id}/newPassengerRequest")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public FlightsModelOutput signal_1(@PathParam(value="id") String id, PassengerDTO data) {
        return (FlightsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.send(Sig.of((String)"newPassengerRequest", (Object)data));
            return ((FlightsModel)pi.checkError().variables()).toOutput();
        }).orElse(null));
    }

    @POST
    @Path(value="/{id}/New_Best_Solution")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public FlightsModelOutput signal_2(@PathParam(value="id") String id) {
        return (FlightsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.send(Sig.of((String)"New Best Solution", null));
            return ((FlightsModel)pi.checkError().variables()).toOutput();
        }).orElse(null));
    }

    @POST
    @Path(value="/{id}/newSolution")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public FlightsModelOutput signal_3(@PathParam(value="id") String id, Flight data) {
        return (FlightsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.send(Sig.of((String)"newSolution", (Object)data));
            return ((FlightsModel)pi.checkError().variables()).toOutput();
        }).orElse(null));
    }

    @POST
    @Path(value="/{id}/Passenger_Boarding_Request")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public FlightsModelOutput signal_4(@PathParam(value="id") String id) {
        return (FlightsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.send(Sig.of((String)"Passenger Boarding Request", null));
            return ((FlightsModel)pi.checkError().variables()).toOutput();
        }).orElse(null));
    }

    @POST
    @Path(value="/{id}/finalizeSeatAssignment/{workItemId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public FlightsModelOutput completeTask_finalizeSeatAssignment_5(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="phase") @DefaultValue(value="complete") String phase, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups, Flights_6_TaskOutput model) {
        return (FlightsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, (Transition)HumanTaskTransition.withModel((String)phase, (MapOutput)model, (Policy[])this.policies(user, groups)));
            return ((FlightsModel)pi.variables()).toOutput();
        }).orElse(null));
    }

    @GET
    @Path(value="/{id}/finalizeSeatAssignment/{workItemId}")
    @Produces(value={"application/json"})
    public Flights_6_TaskInput getTask_finalizeSeatAssignment_5(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> Flights_6_TaskInput.from((WorkItem)pi.workItem(workItemId, this.policies(user, groups)))).orElse(null);
    }

    @GET
    @Path(value="finalizeSeatAssignment/schema")
    @Produces(value={"application/json"})
    public Map<String, Object> getSchema_finalizeSeatAssignment_5() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"finalizeSeatAssignment");
    }

    @GET
    @Path(value="/{id}/finalizeSeatAssignment/{workItemId}/schema")
    @Produces(value={"application/json"})
    public Map<String, Object> getSchemaAndPhases_finalizeSeatAssignment_5(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return JsonSchemaUtil.addPhases((Process)this.process, (Application)this.application, (String)id, (String)workItemId, (Policy[])this.policies(user, groups), (Map)JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"finalizeSeatAssignment"));
    }

    @DELETE
    @Path(value="/{id}/finalizeSeatAssignment/{workItemId}")
    @Produces(value={"application/json"})
    public FlightsModelOutput abortTask_finalizeSeatAssignment_5(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="phase") @DefaultValue(value="abort") String phase, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return (FlightsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, (Transition)HumanTaskTransition.withoutModel((String)phase, (Policy[])this.policies(user, groups)));
            return ((FlightsModel)pi.variables()).toOutput();
        }).orElse(null));
    }

    @POST
    @Path(value="/{id}/finalizePassengerList/{workItemId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public FlightsModelOutput completeTask_finalizePassengerList_6(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="phase") @DefaultValue(value="complete") String phase, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups, Flights_7_TaskOutput model) {
        return (FlightsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, (Transition)HumanTaskTransition.withModel((String)phase, (MapOutput)model, (Policy[])this.policies(user, groups)));
            return ((FlightsModel)pi.variables()).toOutput();
        }).orElse(null));
    }

    @GET
    @Path(value="/{id}/finalizePassengerList/{workItemId}")
    @Produces(value={"application/json"})
    public Flights_7_TaskInput getTask_finalizePassengerList_6(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> Flights_7_TaskInput.from((WorkItem)pi.workItem(workItemId, this.policies(user, groups)))).orElse(null);
    }

    @GET
    @Path(value="finalizePassengerList/schema")
    @Produces(value={"application/json"})
    public Map<String, Object> getSchema_finalizePassengerList_6() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"finalizePassengerList");
    }

    @GET
    @Path(value="/{id}/finalizePassengerList/{workItemId}/schema")
    @Produces(value={"application/json"})
    public Map<String, Object> getSchemaAndPhases_finalizePassengerList_6(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return JsonSchemaUtil.addPhases((Process)this.process, (Application)this.application, (String)id, (String)workItemId, (Policy[])this.policies(user, groups), (Map)JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"finalizePassengerList"));
    }

    @DELETE
    @Path(value="/{id}/finalizePassengerList/{workItemId}")
    @Produces(value={"application/json"})
    public FlightsModelOutput abortTask_finalizePassengerList_6(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="phase") @DefaultValue(value="abort") String phase, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return (FlightsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, (Transition)HumanTaskTransition.withoutModel((String)phase, (Policy[])this.policies(user, groups)));
            return ((FlightsModel)pi.variables()).toOutput();
        }).orElse(null));
    }

    @POST
    @Path(value="/{id}/approveDenyPassenger/{workItemId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public FlightsModelOutput completeTask_approveDenyPassenger_7(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="phase") @DefaultValue(value="complete") String phase, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups, Flights_18_TaskOutput model) {
        return (FlightsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, (Transition)HumanTaskTransition.withModel((String)phase, (MapOutput)model, (Policy[])this.policies(user, groups)));
            return ((FlightsModel)pi.variables()).toOutput();
        }).orElse(null));
    }

    @GET
    @Path(value="/{id}/approveDenyPassenger/{workItemId}")
    @Produces(value={"application/json"})
    public Flights_18_TaskInput getTask_approveDenyPassenger_7(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> Flights_18_TaskInput.from((WorkItem)pi.workItem(workItemId, this.policies(user, groups)))).orElse(null);
    }

    @GET
    @Path(value="approveDenyPassenger/schema")
    @Produces(value={"application/json"})
    public Map<String, Object> getSchema_approveDenyPassenger_7() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"approveDenyPassenger");
    }

    @GET
    @Path(value="/{id}/approveDenyPassenger/{workItemId}/schema")
    @Produces(value={"application/json"})
    public Map<String, Object> getSchemaAndPhases_approveDenyPassenger_7(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return JsonSchemaUtil.addPhases((Process)this.process, (Application)this.application, (String)id, (String)workItemId, (Policy[])this.policies(user, groups), (Map)JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"approveDenyPassenger"));
    }

    @DELETE
    @Path(value="/{id}/approveDenyPassenger/{workItemId}")
    @Produces(value={"application/json"})
    public FlightsModelOutput abortTask_approveDenyPassenger_7(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="phase") @DefaultValue(value="abort") String phase, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return (FlightsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, (Transition)HumanTaskTransition.withoutModel((String)phase, (Policy[])this.policies(user, groups)));
            return ((FlightsModel)pi.variables()).toOutput();
        }).orElse(null));
    }
}

