package org.kie.kogito.examples;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.kie.api.runtime.process.WorkItemNotFoundException;
import org.jbpm.util.JsonSchemaUtil;
import org.kie.kogito.Application;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceExecutionException;
import org.kie.kogito.process.ProcessInstanceNotFoundException;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policies;
import org.kie.kogito.process.impl.Sig;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.auth.IdentityProvider;
import org.jbpm.process.instance.impl.humantask.HumanTaskTransition;
import org.kie.kogito.examples.FlightsModelOutput;

@Path("/flights")
@org.springframework.stereotype.Component()
public class FlightsResource {

    @org.springframework.beans.factory.annotation.Autowired()
    @org.springframework.beans.factory.annotation.Qualifier("flights")
    Process<FlightsModel> process;

    @org.springframework.beans.factory.annotation.Autowired()
    Application application;

    @POST
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    public Response createResource_flights(@Context HttpHeaders httpHeaders, @Context UriInfo uriInfo, @QueryParam("businessKey") String businessKey, @javax.validation.Valid() @javax.validation.constraints.NotNull() FlightsModelInput resource) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            FlightsModelInput inputModel = resource != null ? resource : new FlightsModelInput();
            ProcessInstance<FlightsModel> pi = process.createInstance(businessKey, inputModel.toModel());
            String startFromNode = httpHeaders.getHeaderString("X-KOGITO-StartFromNode");
            if (startFromNode != null) {
                pi.startFrom(startFromNode);
            } else {
                pi.start();
            }
            UriBuilder uriBuilder = uriInfo.getAbsolutePathBuilder().path(pi.id());
            return Response.created(uriBuilder.build()).entity(pi.checkError().variables().toOutput()).build();
        });
    }

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    public List<FlightsModelOutput> getResources_flights() {
        return process.instances().values().stream().map(pi -> pi.variables().toOutput()).collect(Collectors.toList());
    }

    @GET
    @Path("/{id}")
    @Produces(MediaType.APPLICATION_JSON)
    public FlightsModelOutput getResource_flights(@PathParam("id") String id) {
        return process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> pi.variables().toOutput()).orElseThrow(() -> new NotFoundException());
    }

    @DELETE
    @Path("/{id}")
    @Produces(MediaType.APPLICATION_JSON)
    public FlightsModelOutput deleteResource_flights(@PathParam("id") final String id) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.abort();
            return pi.checkError().variables().toOutput();
        }).orElseThrow(() -> new NotFoundException()));
    }

    @PUT
    @Path("/{id}")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public FlightsModelOutput updateModel_flights(@PathParam("id") String id, FlightsModel resource) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> pi.updateVariables(resource).toOutput()).orElseThrow(() -> new NotFoundException()));
    }

    @GET
    @Path("/{id}/tasks")
    @Produces(MediaType.APPLICATION_JSON)
    public List<WorkItem> getTasks_flights(@PathParam("id") String id, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> pi.workItems(Policies.of(user, groups))).orElseThrow(() -> new NotFoundException());
    }

    @POST
    @Path("/{id}/solvingTerminated")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public org.kie.kogito.examples.FlightsModelOutput signal_0(@PathParam("id") final String id, final org.kie.kogito.examples.domain.Flight data) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            return process.instances().findById(id).map(pi -> {
                pi.send(Sig.of("solvingTerminated", data));
                return pi.checkError().variables().toOutput();
            }).orElseThrow(() -> new NotFoundException());
        });
    }

    @POST
    @Path("/{id}/newPassengerRequest")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public org.kie.kogito.examples.FlightsModelOutput signal_1(@PathParam("id") final String id, final org.kie.kogito.examples.domain.PassengerDTO data) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            return process.instances().findById(id).map(pi -> {
                pi.send(Sig.of("newPassengerRequest", data));
                return pi.checkError().variables().toOutput();
            }).orElseThrow(() -> new NotFoundException());
        });
    }

    @POST
    @Path("/{id}/New_Best_Solution")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public org.kie.kogito.examples.FlightsModelOutput signal_2(@PathParam("id") final String id) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            return process.instances().findById(id).map(pi -> {
                pi.send(Sig.of("New Best Solution", null));
                return pi.checkError().variables().toOutput();
            }).orElseThrow(() -> new NotFoundException());
        });
    }

    @POST
    @Path("/{id}/newSolution")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public org.kie.kogito.examples.FlightsModelOutput signal_3(@PathParam("id") final String id, final org.kie.kogito.examples.domain.Flight data) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            return process.instances().findById(id).map(pi -> {
                pi.send(Sig.of("newSolution", data));
                return pi.checkError().variables().toOutput();
            }).orElseThrow(() -> new NotFoundException());
        });
    }

    @POST
    @Path("/{id}/Passenger_Boarding_Request")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public org.kie.kogito.examples.FlightsModelOutput signal_4(@PathParam("id") final String id) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            return process.instances().findById(id).map(pi -> {
                pi.send(Sig.of("Passenger Boarding Request", null));
                return pi.checkError().variables().toOutput();
            }).orElseThrow(() -> new NotFoundException());
        });
    }

    @POST
    @Path("/{id}/finalizeSeatAssignment/{workItemId}")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public FlightsModelOutput completeTask_finalizeSeatAssignment_5(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("phase") @DefaultValue("complete") final String phase, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups, final Flights_6_TaskOutput model) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, HumanTaskTransition.withModel(phase, model, Policies.of(user, groups)));
            return pi.variables().toOutput();
        }).orElseThrow(() -> new NotFoundException()));
    }

    @GET
    @Path("/{id}/finalizeSeatAssignment/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public Flights_6_TaskInput getTask_finalizeSeatAssignment_5(@PathParam("id") String id, @PathParam("workItemId") String workItemId, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> Flights_6_TaskInput.from(pi.workItem(workItemId, Policies.of(user, groups)))).orElseThrow(() -> new NotFoundException());
    }

    @GET
    @Path("finalizeSeatAssignment/schema")
    @Produces(MediaType.APPLICATION_JSON)
    public Map<String, Object> getSchema_finalizeSeatAssignment_5() {
        return JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "finalizeSeatAssignment");
    }

    @GET
    @Path("/{id}/finalizeSeatAssignment/{workItemId}/schema")
    @Produces(MediaType.APPLICATION_JSON)
    public Map<String, Object> getSchemaAndPhases_finalizeSeatAssignment_5(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return JsonSchemaUtil.addPhases(process, application, id, workItemId, Policies.of(user, groups), JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "finalizeSeatAssignment"));
    }

    @DELETE
    @Path("/{id}/finalizeSeatAssignment/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public FlightsModelOutput abortTask_finalizeSeatAssignment_5(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("phase") @DefaultValue("abort") final String phase, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, HumanTaskTransition.withoutModel(phase, Policies.of(user, groups)));
            return pi.variables().toOutput();
        }).orElseThrow(() -> new NotFoundException()));
    }

    @POST
    @Path("/{id}/finalizePassengerList/{workItemId}")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public FlightsModelOutput completeTask_finalizePassengerList_6(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("phase") @DefaultValue("complete") final String phase, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups, final Flights_7_TaskOutput model) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, HumanTaskTransition.withModel(phase, model, Policies.of(user, groups)));
            return pi.variables().toOutput();
        }).orElseThrow(() -> new NotFoundException()));
    }

    @GET
    @Path("/{id}/finalizePassengerList/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public Flights_7_TaskInput getTask_finalizePassengerList_6(@PathParam("id") String id, @PathParam("workItemId") String workItemId, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> Flights_7_TaskInput.from(pi.workItem(workItemId, Policies.of(user, groups)))).orElseThrow(() -> new NotFoundException());
    }

    @GET
    @Path("finalizePassengerList/schema")
    @Produces(MediaType.APPLICATION_JSON)
    public Map<String, Object> getSchema_finalizePassengerList_6() {
        return JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "finalizePassengerList");
    }

    @GET
    @Path("/{id}/finalizePassengerList/{workItemId}/schema")
    @Produces(MediaType.APPLICATION_JSON)
    public Map<String, Object> getSchemaAndPhases_finalizePassengerList_6(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return JsonSchemaUtil.addPhases(process, application, id, workItemId, Policies.of(user, groups), JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "finalizePassengerList"));
    }

    @DELETE
    @Path("/{id}/finalizePassengerList/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public FlightsModelOutput abortTask_finalizePassengerList_6(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("phase") @DefaultValue("abort") final String phase, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, HumanTaskTransition.withoutModel(phase, Policies.of(user, groups)));
            return pi.variables().toOutput();
        }).orElseThrow(() -> new NotFoundException()));
    }

    @POST
    @Path("/{id}/approveDenyPassenger/{workItemId}")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public FlightsModelOutput completeTask_approveDenyPassenger_7(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("phase") @DefaultValue("complete") final String phase, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups, final Flights_18_TaskOutput model) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, HumanTaskTransition.withModel(phase, model, Policies.of(user, groups)));
            return pi.variables().toOutput();
        }).orElseThrow(() -> new NotFoundException()));
    }

    @GET
    @Path("/{id}/approveDenyPassenger/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public Flights_18_TaskInput getTask_approveDenyPassenger_7(@PathParam("id") String id, @PathParam("workItemId") String workItemId, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> Flights_18_TaskInput.from(pi.workItem(workItemId, Policies.of(user, groups)))).orElseThrow(() -> new NotFoundException());
    }

    @GET
    @Path("approveDenyPassenger/schema")
    @Produces(MediaType.APPLICATION_JSON)
    public Map<String, Object> getSchema_approveDenyPassenger_7() {
        return JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "approveDenyPassenger");
    }

    @GET
    @Path("/{id}/approveDenyPassenger/{workItemId}/schema")
    @Produces(MediaType.APPLICATION_JSON)
    public Map<String, Object> getSchemaAndPhases_approveDenyPassenger_7(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return JsonSchemaUtil.addPhases(process, application, id, workItemId, Policies.of(user, groups), JsonSchemaUtil.load(this.getClass().getClassLoader(), process.id(), "approveDenyPassenger"));
    }

    @DELETE
    @Path("/{id}/approveDenyPassenger/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public FlightsModelOutput abortTask_approveDenyPassenger_7(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("phase") @DefaultValue("abort") final String phase, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, HumanTaskTransition.withoutModel(phase, Policies.of(user, groups)));
            return pi.variables().toOutput();
        }).orElseThrow(() -> new NotFoundException()));
    }
}
