/*
 * Copyright 2019 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kie.kogito.examples;

import java.util.Map;
import java.util.HashMap;
import org.kie.kogito.UserTask;
import org.kie.kogito.UserTaskParam.ParamType;
import org.kie.kogito.UserTaskParam;

@UserTask(taskName = "finalizePassengerList", processName = "flights")
public class Flights_7_TaskOutput implements org.kie.kogito.MapOutput {

    public Map<String, Object> toMap() {
        Map<String, Object> params = new HashMap<>();
        params.put("isPassengerListFinalized", this.isPassengerListFinalized);
        return params;
    }

    public static Flights_7_TaskOutput fromMap(Map<String, Object> params) {
        org.kie.kogito.examples.Flights_7_TaskOutput result = new Flights_7_TaskOutput();
        result.isPassengerListFinalized = (java.lang.Boolean) params.get("isPassengerListFinalized");
        return result;
    }

    @UserTaskParam(value = ParamType.OUTPUT)
    private java.lang.Boolean isPassengerListFinalized;

    public java.lang.Boolean getIsPassengerListFinalized() {
        return isPassengerListFinalized;
    }

    public void setIsPassengerListFinalized(java.lang.Boolean isPassengerListFinalized) {
        this.isPassengerListFinalized = isPassengerListFinalized;
    }
}
// Task output for user task 'Finalize Passenger List' in process 'flights'
