/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import io.swagger.v3.oas.annotations.Operation;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jbpm.util.JsonSchemaUtil;
import org.kie.kogito.MapOutput;
import org.kie.kogito.MappableToModel;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.IdentityProviders;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.examples.OrderItemsModel;
import org.kie.kogito.examples.OrderItemsModelOutput;
import org.kie.kogito.examples.OrderItems_4_TaskModel;
import org.kie.kogito.examples.OrderItems_4_TaskOutput;
import org.kie.kogito.examples.OrderItems_TaskModelFactory;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessService;
import org.kie.kogito.process.workitem.Attachment;
import org.kie.kogito.process.workitem.AttachmentInfo;
import org.kie.kogito.process.workitem.Comment;
import org.kie.kogito.process.workitem.TaskModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/orderItems"})
@Component
public class OrderItemsResource {
    @Autowired
    @Qualifier(value="demo.orderItems")
    Process<OrderItemsModel> process;
    @Autowired
    ProcessService processService;

    @GetMapping(produces={"application/json"})
    @Operation(summary="orderItems", description="")
    public List<OrderItemsModelOutput> getResources_orderItems() {
        return this.processService.getProcessInstanceOutput(this.process);
    }

    @GetMapping(value={"/schema"}, produces={"application/json"})
    @Operation(summary="orderItems", description="")
    public Map<String, Object> getResourceSchema_orderItems() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id());
    }

    @GetMapping(value={"/{id}"}, produces={"application/json"})
    @Operation(summary="orderItems", description="")
    public OrderItemsModelOutput getResource_orderItems(@PathVariable(value="id") String id) {
        return (OrderItemsModelOutput)this.processService.findById(this.process, id).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}"}, produces={"application/json"})
    @Operation(summary="orderItems", description="")
    public OrderItemsModelOutput deleteResource_orderItems(@PathVariable(value="id") String id) {
        return (OrderItemsModelOutput)this.processService.delete(this.process, id).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}"}, produces={"application/json"}, consumes={"application/json"})
    @Operation(summary="orderItems", description="")
    public OrderItemsModelOutput updateModel_orderItems(@PathVariable(value="id") String id, @RequestBody(required=false) OrderItemsModel resource) {
        return (OrderItemsModelOutput)this.processService.update(this.process, id, (MappableToModel)resource).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/tasks"}, produces={"application/json"})
    @Operation(summary="orderItems", description="")
    public List<TaskModel> getTasks_orderItems(@PathVariable(value="id") String id, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return ((List)this.processService.getTasks(this.process, id, SecurityPolicy.of((IdentityProvider)IdentityProviders.of((String)user, groups))).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND))).stream().map(OrderItems_TaskModelFactory::from).collect(Collectors.toList());
    }

    @PostMapping(value={"/{id}/Verify_order/{taskId}/phases/{phase}"}, produces={"application/json"}, consumes={"application/json"})
    public OrderItemsModelOutput completeTask_Verify_order_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="phase") String phase, @RequestParam(value="user") String user, @RequestParam(value="group") List<String> groups, @RequestBody(required=false) OrderItems_4_TaskOutput model) {
        return (OrderItemsModelOutput)this.processService.taskTransition(this.process, id, taskId, phase, SecurityPolicy.of((String)user, groups), (MapOutput)model).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}/Verify_order/{taskId}"}, consumes={"application/json"})
    public OrderItems_4_TaskOutput saveTask_Verify_order_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody(required=false) OrderItems_4_TaskOutput model) {
        return (OrderItems_4_TaskOutput)this.processService.saveTask(this.process, id, taskId, SecurityPolicy.of((String)user, groups), (MapOutput)model, OrderItems_4_TaskOutput::fromMap).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PostMapping(value={"/{id}/Verify_order/{taskId}"}, produces={"application/json"}, consumes={"application/json"})
    public OrderItemsModelOutput taskTransition_Verify_order_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="phase", required=false, defaultValue="complete") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody(required=false) OrderItems_4_TaskOutput model) {
        return (OrderItemsModelOutput)this.processService.taskTransition(this.process, id, taskId, phase, SecurityPolicy.of((String)user, groups), (MapOutput)model).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/Verify_order/{taskId}"}, produces={"application/json"})
    public OrderItems_4_TaskModel getTask_Verify_order_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (OrderItems_4_TaskModel)this.processService.getTask(this.process, id, taskId, SecurityPolicy.of((String)user, groups), OrderItems_4_TaskModel::from).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}/Verify_order/{taskId}"}, produces={"application/json"})
    public OrderItemsModelOutput abortTask_Verify_order_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="phase", required=false, defaultValue="abort") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (OrderItemsModelOutput)this.processService.taskTransition(this.process, id, taskId, phase, SecurityPolicy.of((String)user, groups), null).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"Verify_order/schema"}, produces={"application/json"})
    public Map<String, Object> getSchema_Verify_order_0() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"Verify_order");
    }

    @GetMapping(value={"/{id}/Verify_order/{taskId}/schema"}, produces={"application/json"})
    public Map<String, Object> getSchemaAndPhases_Verify_order_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.processService.getSchemaAndPhases(this.process, id, taskId, "Verify_order", SecurityPolicy.of((String)user, groups));
    }

    @PostMapping(value={"/{id}/Verify_order/{taskId}/comments"}, produces={"application/json"}, consumes={"text/plain"})
    public ResponseEntity<Comment> addComment_Verify_order_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody String commentInfo, UriComponentsBuilder uriComponentsBuilder) {
        return this.processService.addComment(this.process, id, taskId, SecurityPolicy.of((String)user, groups), commentInfo).map(comment -> ResponseEntity.created((URI)uriComponentsBuilder.path("/orderItems/{id}/Verify_order/{taskId}/comments/{commentId}").buildAndExpand(new Object[]{id, taskId, comment.getId().toString()}).toUri()).body(comment)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}/Verify_order/{taskId}/comments/{commentId}"}, produces={"application/json"}, consumes={"text/plain"})
    public Comment updateComment_Verify_order_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody String comment) {
        return (Comment)this.processService.updateComment(this.process, id, taskId, commentId, SecurityPolicy.of((String)user, groups), comment).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}/Verify_order/{taskId}/comments/{commentId}"})
    public ResponseEntity deleteComment_Verify_order_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.processService.deleteComment(this.process, id, taskId, commentId, SecurityPolicy.of((String)user, groups)).map(removed -> removed != false ? ResponseEntity.ok().build() : ResponseEntity.notFound().build()).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PostMapping(value={"/{id}/Verify_order/{taskId}/attachments"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Attachment> addAttachment_Verify_order_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody AttachmentInfo attachmentInfo, UriComponentsBuilder uriComponentsBuilder) {
        return this.processService.addAttachment(this.process, id, taskId, SecurityPolicy.of((String)user, groups), attachmentInfo).map(attachment -> ResponseEntity.created((URI)uriComponentsBuilder.path("/orderItems/{id}/Verify_order/{taskId}/attachments/{attachmentId}").buildAndExpand(new Object[]{id, taskId, attachment.getId()}).toUri()).body(attachment)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}/Verify_order/{taskId}/attachments/{attachmentId}"}, produces={"application/json"}, consumes={"application/json"})
    public Attachment updateAttachment_Verify_order_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody AttachmentInfo attachment) {
        return (Attachment)this.processService.updateAttachment(this.process, id, taskId, attachmentId, SecurityPolicy.of((String)user, groups), attachment).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}/Verify_order/{taskId}/attachments/{attachmentId}"})
    public ResponseEntity deleteAttachment_Verify_order_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.processService.deleteAttachment(this.process, id, taskId, attachmentId, SecurityPolicy.of((String)user, groups)).map(removed -> (removed != false ? ResponseEntity.ok() : ResponseEntity.notFound()).build()).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/Verify_order/{taskId}/attachments/{attachmentId}"}, produces={"application/json"})
    public Attachment getAttachment_Verify_order_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Attachment)this.processService.getAttachment(this.process, id, taskId, attachmentId, SecurityPolicy.of((String)user, groups)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, "Attachment " + attachmentId + " not found"));
    }

    @GetMapping(value={"/{id}/Verify_order/{taskId}/attachments"}, produces={"application/json"})
    public Collection<Attachment> getAttachments_Verify_order_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user") String user, @RequestParam(value="group") List<String> groups) {
        return (Collection)this.processService.getAttachments(this.process, id, taskId, SecurityPolicy.of((String)user, groups)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/Verify_order/{taskId}/comments/{commentId}"}, produces={"application/json"})
    public Comment getComment_Verify_order_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Comment)this.processService.getComment(this.process, id, taskId, commentId, SecurityPolicy.of((String)user, groups)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, "Comment " + commentId + " not found"));
    }

    @GetMapping(value={"/{id}/Verify_order/{taskId}/comments"}, produces={"application/json"})
    public Collection<Comment> getComments_Verify_order_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Collection)this.processService.getComments(this.process, id, taskId, SecurityPolicy.of((String)user, groups)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }
}

