/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples.demo;

import io.swagger.v3.oas.annotations.Operation;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.jbpm.util.JsonSchemaUtil;
import org.kie.kogito.MapOutput;
import org.kie.kogito.MappableToModel;
import org.kie.kogito.Model;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.IdentityProviders;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.examples.demo.PersonsModel;
import org.kie.kogito.examples.demo.PersonsModelInput;
import org.kie.kogito.examples.demo.PersonsModelOutput;
import org.kie.kogito.examples.demo.Persons_4_TaskModel;
import org.kie.kogito.examples.demo.Persons_4_TaskOutput;
import org.kie.kogito.examples.demo.Persons_TaskModelFactory;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessService;
import org.kie.kogito.process.workitem.Attachment;
import org.kie.kogito.process.workitem.AttachmentInfo;
import org.kie.kogito.process.workitem.Comment;
import org.kie.kogito.process.workitem.TaskModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/persons"})
@Component
public class PersonsResource {
    @Autowired
    @Qualifier(value="persons")
    Process<PersonsModel> process;
    @Autowired
    ProcessService processService;

    @PostMapping(produces={"application/json"}, consumes={"application/json"})
    @Operation(summary="persons", description="")
    public ResponseEntity<PersonsModelOutput> createResource_persons(@RequestHeader HttpHeaders httpHeaders, @RequestParam(value="businessKey", required=false) String businessKey, @RequestBody(required=false) @Valid @NotNull PersonsModelInput resource, UriComponentsBuilder uriComponentsBuilder) {
        ProcessInstance pi = this.processService.createProcessInstance(this.process, businessKey, (Model)Optional.ofNullable(resource).orElse(new PersonsModelInput()).toModel(), (String)httpHeaders.getOrEmpty((Object)"X-KOGITO-StartFromNode").stream().findFirst().orElse(null));
        return ResponseEntity.created((URI)uriComponentsBuilder.path("/persons/{id}").buildAndExpand(new Object[]{pi.id()}).toUri()).body((Object)((PersonsModel)pi.checkError().variables()).toModel());
    }

    @GetMapping(produces={"application/json"})
    @Operation(summary="persons", description="")
    public List<PersonsModelOutput> getResources_persons() {
        return this.processService.getProcessInstanceOutput(this.process);
    }

    @GetMapping(value={"/schema"}, produces={"application/json"})
    @Operation(summary="persons", description="")
    public Map<String, Object> getResourceSchema_persons() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id());
    }

    @GetMapping(value={"/{id}"}, produces={"application/json"})
    @Operation(summary="persons", description="")
    public PersonsModelOutput getResource_persons(@PathVariable(value="id") String id) {
        return (PersonsModelOutput)this.processService.findById(this.process, id).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}"}, produces={"application/json"})
    @Operation(summary="persons", description="")
    public PersonsModelOutput deleteResource_persons(@PathVariable(value="id") String id) {
        return (PersonsModelOutput)this.processService.delete(this.process, id).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}"}, produces={"application/json"}, consumes={"application/json"})
    @Operation(summary="persons", description="")
    public PersonsModelOutput updateModel_persons(@PathVariable(value="id") String id, @RequestBody(required=false) PersonsModel resource) {
        return (PersonsModelOutput)this.processService.update(this.process, id, (MappableToModel)resource).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/tasks"}, produces={"application/json"})
    @Operation(summary="persons", description="")
    public List<TaskModel> getTasks_persons(@PathVariable(value="id") String id, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return ((List)this.processService.getTasks(this.process, id, SecurityPolicy.of((IdentityProvider)IdentityProviders.of((String)user, groups))).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND))).stream().map(Persons_TaskModelFactory::from).collect(Collectors.toList());
    }

    @PostMapping(value={"/{id}/ChildrenHandling/{taskId}/phases/{phase}"}, produces={"application/json"}, consumes={"application/json"})
    public PersonsModelOutput completeTask_ChildrenHandling_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="phase") String phase, @RequestParam(value="user") String user, @RequestParam(value="group") List<String> groups, @RequestBody(required=false) Persons_4_TaskOutput model) {
        return (PersonsModelOutput)this.processService.taskTransition(this.process, id, taskId, phase, SecurityPolicy.of((String)user, groups), (MapOutput)model).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}/ChildrenHandling/{taskId}"}, consumes={"application/json"})
    public Persons_4_TaskOutput saveTask_ChildrenHandling_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody(required=false) Persons_4_TaskOutput model) {
        return (Persons_4_TaskOutput)this.processService.saveTask(this.process, id, taskId, SecurityPolicy.of((String)user, groups), (MapOutput)model, Persons_4_TaskOutput::fromMap).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PostMapping(value={"/{id}/ChildrenHandling/{taskId}"}, produces={"application/json"}, consumes={"application/json"})
    public PersonsModelOutput taskTransition_ChildrenHandling_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="phase", required=false, defaultValue="complete") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody(required=false) Persons_4_TaskOutput model) {
        return (PersonsModelOutput)this.processService.taskTransition(this.process, id, taskId, phase, SecurityPolicy.of((String)user, groups), (MapOutput)model).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/ChildrenHandling/{taskId}"}, produces={"application/json"})
    public Persons_4_TaskModel getTask_ChildrenHandling_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Persons_4_TaskModel)this.processService.getTask(this.process, id, taskId, SecurityPolicy.of((String)user, groups), Persons_4_TaskModel::from).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}/ChildrenHandling/{taskId}"}, produces={"application/json"})
    public PersonsModelOutput abortTask_ChildrenHandling_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="phase", required=false, defaultValue="abort") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (PersonsModelOutput)this.processService.taskTransition(this.process, id, taskId, phase, SecurityPolicy.of((String)user, groups), null).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"ChildrenHandling/schema"}, produces={"application/json"})
    public Map<String, Object> getSchema_ChildrenHandling_0() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"ChildrenHandling");
    }

    @GetMapping(value={"/{id}/ChildrenHandling/{taskId}/schema"}, produces={"application/json"})
    public Map<String, Object> getSchemaAndPhases_ChildrenHandling_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.processService.getSchemaAndPhases(this.process, id, taskId, "ChildrenHandling", SecurityPolicy.of((String)user, groups));
    }

    @PostMapping(value={"/{id}/ChildrenHandling/{taskId}/comments"}, produces={"application/json"}, consumes={"text/plain"})
    public ResponseEntity<Comment> addComment_ChildrenHandling_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody String commentInfo, UriComponentsBuilder uriComponentsBuilder) {
        return this.processService.addComment(this.process, id, taskId, SecurityPolicy.of((String)user, groups), commentInfo).map(comment -> ResponseEntity.created((URI)uriComponentsBuilder.path("/persons/{id}/ChildrenHandling/{taskId}/comments/{commentId}").buildAndExpand(new Object[]{id, taskId, comment.getId().toString()}).toUri()).body(comment)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}/ChildrenHandling/{taskId}/comments/{commentId}"}, produces={"application/json"}, consumes={"text/plain"})
    public Comment updateComment_ChildrenHandling_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody String comment) {
        return (Comment)this.processService.updateComment(this.process, id, taskId, commentId, SecurityPolicy.of((String)user, groups), comment).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}/ChildrenHandling/{taskId}/comments/{commentId}"})
    public ResponseEntity deleteComment_ChildrenHandling_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.processService.deleteComment(this.process, id, taskId, commentId, SecurityPolicy.of((String)user, groups)).map(removed -> removed != false ? ResponseEntity.ok().build() : ResponseEntity.notFound().build()).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PostMapping(value={"/{id}/ChildrenHandling/{taskId}/attachments"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Attachment> addAttachment_ChildrenHandling_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody AttachmentInfo attachmentInfo, UriComponentsBuilder uriComponentsBuilder) {
        return this.processService.addAttachment(this.process, id, taskId, SecurityPolicy.of((String)user, groups), attachmentInfo).map(attachment -> ResponseEntity.created((URI)uriComponentsBuilder.path("/persons/{id}/ChildrenHandling/{taskId}/attachments/{attachmentId}").buildAndExpand(new Object[]{id, taskId, attachment.getId()}).toUri()).body(attachment)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}/ChildrenHandling/{taskId}/attachments/{attachmentId}"}, produces={"application/json"}, consumes={"application/json"})
    public Attachment updateAttachment_ChildrenHandling_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody AttachmentInfo attachment) {
        return (Attachment)this.processService.updateAttachment(this.process, id, taskId, attachmentId, SecurityPolicy.of((String)user, groups), attachment).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}/ChildrenHandling/{taskId}/attachments/{attachmentId}"})
    public ResponseEntity deleteAttachment_ChildrenHandling_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.processService.deleteAttachment(this.process, id, taskId, attachmentId, SecurityPolicy.of((String)user, groups)).map(removed -> (removed != false ? ResponseEntity.ok() : ResponseEntity.notFound()).build()).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/ChildrenHandling/{taskId}/attachments/{attachmentId}"}, produces={"application/json"})
    public Attachment getAttachment_ChildrenHandling_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Attachment)this.processService.getAttachment(this.process, id, taskId, attachmentId, SecurityPolicy.of((String)user, groups)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, "Attachment " + attachmentId + " not found"));
    }

    @GetMapping(value={"/{id}/ChildrenHandling/{taskId}/attachments"}, produces={"application/json"})
    public Collection<Attachment> getAttachments_ChildrenHandling_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user") String user, @RequestParam(value="group") List<String> groups) {
        return (Collection)this.processService.getAttachments(this.process, id, taskId, SecurityPolicy.of((String)user, groups)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/ChildrenHandling/{taskId}/comments/{commentId}"}, produces={"application/json"})
    public Comment getComment_ChildrenHandling_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Comment)this.processService.getComment(this.process, id, taskId, commentId, SecurityPolicy.of((String)user, groups)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, "Comment " + commentId + " not found"));
    }

    @GetMapping(value={"/{id}/ChildrenHandling/{taskId}/comments"}, produces={"application/json"})
    public Collection<Comment> getComments_ChildrenHandling_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Collection)this.processService.getComments(this.process, id, taskId, SecurityPolicy.of((String)user, groups)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }
}

