/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import io.swagger.v3.oas.annotations.Operation;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.jbpm.util.JsonSchemaUtil;
import org.kie.kogito.MappableToModel;
import org.kie.kogito.Model;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.IdentityProviders;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.examples.OrdersModel;
import org.kie.kogito.examples.OrdersModelInput;
import org.kie.kogito.examples.OrdersModelOutput;
import org.kie.kogito.examples.Orders_TaskModelFactory;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessService;
import org.kie.kogito.process.workitem.TaskModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/orders"})
@Component
public class OrdersResource {
    @Autowired
    @Qualifier(value="demo.orders")
    Process<OrdersModel> process;
    @Autowired
    ProcessService processService;

    @PostMapping(produces={"application/json"}, consumes={"application/json"})
    @Operation(summary="Deals with orders created by customer", description="")
    public ResponseEntity<OrdersModelOutput> createResource_orders(@RequestHeader HttpHeaders httpHeaders, @RequestParam(value="businessKey", required=false) String businessKey, @RequestBody(required=false) @Valid @NotNull OrdersModelInput resource, UriComponentsBuilder uriComponentsBuilder) {
        ProcessInstance pi = this.processService.createProcessInstance(this.process, businessKey, (Model)Optional.ofNullable(resource).orElse(new OrdersModelInput()).toModel(), (String)httpHeaders.getOrEmpty((Object)"X-KOGITO-StartFromNode").stream().findFirst().orElse(null));
        return ResponseEntity.created((URI)uriComponentsBuilder.path("/orders/{id}").buildAndExpand(new Object[]{pi.id()}).toUri()).body((Object)((OrdersModel)pi.checkError().variables()).toModel());
    }

    @GetMapping(produces={"application/json"})
    @Operation(summary="Deals with orders created by customer", description="")
    public List<OrdersModelOutput> getResources_orders() {
        return this.processService.getProcessInstanceOutput(this.process);
    }

    @GetMapping(value={"/schema"}, produces={"application/json"})
    @Operation(summary="Deals with orders created by customer", description="")
    public Map<String, Object> getResourceSchema_orders() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id());
    }

    @GetMapping(value={"/{id}"}, produces={"application/json"})
    @Operation(summary="Deals with orders created by customer", description="")
    public OrdersModelOutput getResource_orders(@PathVariable(value="id") String id) {
        return (OrdersModelOutput)this.processService.findById(this.process, id).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}"}, produces={"application/json"})
    @Operation(summary="Deals with orders created by customer", description="")
    public OrdersModelOutput deleteResource_orders(@PathVariable(value="id") String id) {
        return (OrdersModelOutput)this.processService.delete(this.process, id).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}"}, produces={"application/json"}, consumes={"application/json"})
    @Operation(summary="Deals with orders created by customer", description="")
    public OrdersModelOutput updateModel_orders(@PathVariable(value="id") String id, @RequestBody(required=false) OrdersModel resource) {
        return (OrdersModelOutput)this.processService.update(this.process, id, (MappableToModel)resource).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/tasks"}, produces={"application/json"})
    @Operation(summary="Deals with orders created by customer", description="")
    public List<TaskModel> getTasks_orders(@PathVariable(value="id") String id, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return ((List)this.processService.getTasks(this.process, id, SecurityPolicy.of((IdentityProvider)IdentityProviders.of((String)user, groups))).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND))).stream().map(Orders_TaskModelFactory::from).collect(Collectors.toList());
    }
}

