/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travels;

import io.swagger.v3.oas.annotations.Operation;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.acme.travels.TimersOnTaskModel;
import org.acme.travels.TimersOnTaskModelInput;
import org.acme.travels.TimersOnTaskModelOutput;
import org.acme.travels.TimersOnTask_1_TaskModel;
import org.acme.travels.TimersOnTask_1_TaskOutput;
import org.acme.travels.TimersOnTask_TaskModelFactory;
import org.jbpm.util.JsonSchemaUtil;
import org.kie.kogito.MapOutput;
import org.kie.kogito.MappableToModel;
import org.kie.kogito.Model;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.IdentityProviders;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessService;
import org.kie.kogito.process.workitem.Attachment;
import org.kie.kogito.process.workitem.AttachmentInfo;
import org.kie.kogito.process.workitem.Comment;
import org.kie.kogito.process.workitem.TaskModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/timersOnTask"})
@Component
public class TimersOnTaskResource {
    @Autowired
    @Qualifier(value="timersOnTask")
    Process<TimersOnTaskModel> process;
    @Autowired
    ProcessService processService;

    @PostMapping(produces={"application/json"}, consumes={"application/json"})
    @Operation(summary="timersOnTask", description="")
    public ResponseEntity<TimersOnTaskModelOutput> createResource_timersOnTask(@RequestHeader HttpHeaders httpHeaders, @RequestParam(value="businessKey", required=false) String businessKey, @RequestBody(required=false) @Valid @NotNull TimersOnTaskModelInput resource, UriComponentsBuilder uriComponentsBuilder) {
        ProcessInstance pi = this.processService.createProcessInstance(this.process, businessKey, (Model)Optional.ofNullable(resource).orElse(new TimersOnTaskModelInput()).toModel(), (String)httpHeaders.getOrEmpty((Object)"X-KOGITO-StartFromNode").stream().findFirst().orElse(null));
        return ResponseEntity.created((URI)uriComponentsBuilder.path("/timersOnTask/{id}").buildAndExpand(new Object[]{pi.id()}).toUri()).body((Object)((TimersOnTaskModel)pi.checkError().variables()).toModel());
    }

    @GetMapping(produces={"application/json"})
    @Operation(summary="timersOnTask", description="")
    public List<TimersOnTaskModelOutput> getResources_timersOnTask() {
        return this.processService.getProcessInstanceOutput(this.process);
    }

    @GetMapping(value={"/schema"}, produces={"application/json"})
    @Operation(summary="timersOnTask", description="")
    public Map<String, Object> getResourceSchema_timersOnTask() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id());
    }

    @GetMapping(value={"/{id}"}, produces={"application/json"})
    @Operation(summary="timersOnTask", description="")
    public TimersOnTaskModelOutput getResource_timersOnTask(@PathVariable(value="id") String id) {
        return (TimersOnTaskModelOutput)this.processService.findById(this.process, id).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}"}, produces={"application/json"})
    @Operation(summary="timersOnTask", description="")
    public TimersOnTaskModelOutput deleteResource_timersOnTask(@PathVariable(value="id") String id) {
        return (TimersOnTaskModelOutput)this.processService.delete(this.process, id).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}"}, produces={"application/json"}, consumes={"application/json"})
    @Operation(summary="timersOnTask", description="")
    public TimersOnTaskModelOutput updateModel_timersOnTask(@PathVariable(value="id") String id, @RequestBody(required=false) TimersOnTaskModel resource) {
        return (TimersOnTaskModelOutput)this.processService.update(this.process, id, (MappableToModel)resource).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/tasks"}, produces={"application/json"})
    @Operation(summary="timersOnTask", description="")
    public List<TaskModel> getTasks_timersOnTask(@PathVariable(value="id") String id, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return ((List)this.processService.getTasks(this.process, id, SecurityPolicy.of((IdentityProvider)IdentityProviders.of((String)user, groups))).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND))).stream().map(TimersOnTask_TaskModelFactory::from).collect(Collectors.toList());
    }

    @PostMapping(value={"/{id}/work/{taskId}/phases/{phase}"}, produces={"application/json"}, consumes={"application/json"})
    public TimersOnTaskModelOutput completeTask_work_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="phase") String phase, @RequestParam(value="user") String user, @RequestParam(value="group") List<String> groups, @RequestBody(required=false) TimersOnTask_1_TaskOutput model) {
        return (TimersOnTaskModelOutput)this.processService.taskTransition(this.process, id, taskId, phase, SecurityPolicy.of((String)user, groups), (MapOutput)model).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}/work/{taskId}"}, consumes={"application/json"})
    public TimersOnTask_1_TaskOutput saveTask_work_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody(required=false) TimersOnTask_1_TaskOutput model) {
        return (TimersOnTask_1_TaskOutput)this.processService.saveTask(this.process, id, taskId, SecurityPolicy.of((String)user, groups), (MapOutput)model, TimersOnTask_1_TaskOutput::fromMap).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PostMapping(value={"/{id}/work/{taskId}"}, produces={"application/json"}, consumes={"application/json"})
    public TimersOnTaskModelOutput taskTransition_work_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="phase", required=false, defaultValue="complete") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody(required=false) TimersOnTask_1_TaskOutput model) {
        return (TimersOnTaskModelOutput)this.processService.taskTransition(this.process, id, taskId, phase, SecurityPolicy.of((String)user, groups), (MapOutput)model).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/work/{taskId}"}, produces={"application/json"})
    public TimersOnTask_1_TaskModel getTask_work_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (TimersOnTask_1_TaskModel)this.processService.getTask(this.process, id, taskId, SecurityPolicy.of((String)user, groups), TimersOnTask_1_TaskModel::from).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}/work/{taskId}"}, produces={"application/json"})
    public TimersOnTaskModelOutput abortTask_work_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="phase", required=false, defaultValue="abort") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (TimersOnTaskModelOutput)this.processService.taskTransition(this.process, id, taskId, phase, SecurityPolicy.of((String)user, groups), null).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"work/schema"}, produces={"application/json"})
    public Map<String, Object> getSchema_work_0() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"work");
    }

    @GetMapping(value={"/{id}/work/{taskId}/schema"}, produces={"application/json"})
    public Map<String, Object> getSchemaAndPhases_work_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.processService.getSchemaAndPhases(this.process, id, taskId, "work", SecurityPolicy.of((String)user, groups));
    }

    @PostMapping(value={"/{id}/work/{taskId}/comments"}, produces={"application/json"}, consumes={"text/plain"})
    public ResponseEntity<Comment> addComment_work_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody String commentInfo, UriComponentsBuilder uriComponentsBuilder) {
        return this.processService.addComment(this.process, id, taskId, SecurityPolicy.of((String)user, groups), commentInfo).map(comment -> ResponseEntity.created((URI)uriComponentsBuilder.path("/timersOnTask/{id}/work/{taskId}/comments/{commentId}").buildAndExpand(new Object[]{id, taskId, ((String)((Object)comment.getId())).toString()}).toUri()).body(comment)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}/work/{taskId}/comments/{commentId}"}, produces={"application/json"}, consumes={"text/plain"})
    public Comment updateComment_work_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody String comment) {
        return (Comment)this.processService.updateComment(this.process, id, taskId, commentId, SecurityPolicy.of((String)user, groups), comment).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}/work/{taskId}/comments/{commentId}"})
    public ResponseEntity deleteComment_work_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.processService.deleteComment(this.process, id, taskId, commentId, SecurityPolicy.of((String)user, groups)).map(removed -> removed != false ? ResponseEntity.ok().build() : ResponseEntity.notFound().build()).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PostMapping(value={"/{id}/work/{taskId}/attachments"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Attachment> addAttachment_work_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody AttachmentInfo attachmentInfo, UriComponentsBuilder uriComponentsBuilder) {
        return this.processService.addAttachment(this.process, id, taskId, SecurityPolicy.of((String)user, groups), attachmentInfo).map(attachment -> ResponseEntity.created((URI)uriComponentsBuilder.path("/timersOnTask/{id}/work/{taskId}/attachments/{attachmentId}").buildAndExpand(new Object[]{id, taskId, attachment.getId()}).toUri()).body(attachment)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}/work/{taskId}/attachments/{attachmentId}"}, produces={"application/json"}, consumes={"application/json"})
    public Attachment updateAttachment_work_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody AttachmentInfo attachment) {
        return (Attachment)this.processService.updateAttachment(this.process, id, taskId, attachmentId, SecurityPolicy.of((String)user, groups), attachment).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}/work/{taskId}/attachments/{attachmentId}"})
    public ResponseEntity deleteAttachment_work_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.processService.deleteAttachment(this.process, id, taskId, attachmentId, SecurityPolicy.of((String)user, groups)).map(removed -> (removed != false ? ResponseEntity.ok() : ResponseEntity.notFound()).build()).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/work/{taskId}/attachments/{attachmentId}"}, produces={"application/json"})
    public Attachment getAttachment_work_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Attachment)this.processService.getAttachment(this.process, id, taskId, attachmentId, SecurityPolicy.of((String)user, groups)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, "Attachment " + attachmentId + " not found"));
    }

    @GetMapping(value={"/{id}/work/{taskId}/attachments"}, produces={"application/json"})
    public Collection<Attachment> getAttachments_work_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user") String user, @RequestParam(value="group") List<String> groups) {
        return (Collection)this.processService.getAttachments(this.process, id, taskId, SecurityPolicy.of((String)user, groups)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/work/{taskId}/comments/{commentId}"}, produces={"application/json"})
    public Comment getComment_work_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Comment)this.processService.getComment(this.process, id, taskId, commentId, SecurityPolicy.of((String)user, groups)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, "Comment " + commentId + " not found"));
    }

    @GetMapping(value={"/{id}/work/{taskId}/comments"}, produces={"application/json"})
    public Collection<Comment> getComments_work_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Collection)this.processService.getComments(this.process, id, taskId, SecurityPolicy.of((String)user, groups)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }
}

