package org.acme.travels;

import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.ruleflow.core.RuleFlowProcessFactory;
import org.drools.core.util.KieFunctions;

@org.springframework.stereotype.Component("approvals")
public class ApprovalsProcess extends org.kie.kogito.process.impl.AbstractProcess<org.acme.travels.ApprovalsModel> {

    @org.springframework.beans.factory.annotation.Autowired()
    public ApprovalsProcess(org.kie.kogito.app.Application app) {
        super(app, java.util.Arrays.asList());
        activate();
    }

    public ApprovalsProcess() {
    }

    @Override()
    public org.acme.travels.ApprovalsProcessInstance createInstance(org.acme.travels.ApprovalsModel value) {
        return new org.acme.travels.ApprovalsProcessInstance(this, value, this.createProcessRuntime());
    }

    public org.acme.travels.ApprovalsProcessInstance createInstance(java.lang.String businessKey, org.acme.travels.ApprovalsModel value) {
        return new org.acme.travels.ApprovalsProcessInstance(this, value, businessKey, this.createProcessRuntime());
    }

    @Override()
    public org.acme.travels.ApprovalsModel createModel() {
        return new org.acme.travels.ApprovalsModel();
    }

    public org.acme.travels.ApprovalsProcessInstance createInstance(org.kie.kogito.Model value) {
        return this.createInstance((org.acme.travels.ApprovalsModel) value);
    }

    public org.acme.travels.ApprovalsProcessInstance createInstance(java.lang.String businessKey, org.kie.kogito.Model value) {
        return this.createInstance(businessKey, (org.acme.travels.ApprovalsModel) value);
    }

    public org.acme.travels.ApprovalsProcessInstance createInstance(org.kie.api.runtime.process.WorkflowProcessInstance wpi) {
        return new org.acme.travels.ApprovalsProcessInstance(this, this.createModel(), this.createProcessRuntime(), wpi);
    }

    public org.acme.travels.ApprovalsProcessInstance createReadOnlyInstance(org.kie.api.runtime.process.WorkflowProcessInstance wpi) {
        return new org.acme.travels.ApprovalsProcessInstance(this, this.createModel(), wpi);
    }

    public org.kie.api.definition.process.Process process() {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess("approvals");
        factory.variable("approver", new ObjectDataType("java.lang.String"), "customTags", null);
        factory.variable("traveller", new ObjectDataType("org.acme.travels.Traveller"), "customTags", null);
        factory.variable("firstLineApproval", new ObjectDataType("java.lang.Boolean"), "customTags", null);
        factory.variable("secondLineApproval", new ObjectDataType("java.lang.Boolean"), "customTags", null);
        factory.name("approvals");
        factory.packageName("org.acme.travels");
        factory.dynamic(false);
        factory.version("1.0");
        factory.visibility("Public");
        factory.metaData("TargetNamespace", "http://www.omg.org/bpmn20");
        factory.imports("org.acme.travels.Traveller");
        org.jbpm.ruleflow.core.factory.HumanTaskNodeFactory<?> humanTaskNode1 = factory.humanTaskNode(1);
        humanTaskNode1.name("First Line Approval");
        humanTaskNode1.workParameter("TaskName", "firstLineApproval");
        humanTaskNode1.workParameter("NotCompletedReassign", "[users:Pepe,Pepa|groups:Admin,Managers]@[1m]");
        humanTaskNode1.workParameter("NotStartedNotify", "[from:ftirados@localhost.localdomain|tousers:|togroups:|toemails:javierito@gmail.com|replyTo:|subject:just once|body:Can we start already?]@[PT30S]");
        humanTaskNode1.workParameter("NotCompletedNotify", "[from:pepe@mydomain.com|tousers:|togroups:|toemails:ftirados@redhat.com|replyTo:|subject:You need to complete this|body:eventually]@[R/PT1M]");
        humanTaskNode1.workParameter("Skippable", "true");
        humanTaskNode1.workParameter("GroupId", "managers");
        humanTaskNode1.workParameter("ActorId", "manager");
        humanTaskNode1.workParameter("NodeName", "First Line Approval");
        humanTaskNode1.inMapping("traveller", "traveller");
        humanTaskNode1.outMapping("approved", "firstLineApproval");
        humanTaskNode1.outMapping("ActorId", "approver");
        humanTaskNode1.done();
        humanTaskNode1.metaData("UniqueId", "_8B62D3CA-5D03-4B2B-832B-126469288BB4");
        humanTaskNode1.metaData("elementname", "First Line Approval");
        humanTaskNode1.metaData("x", 455);
        humanTaskNode1.metaData("width", 154);
        humanTaskNode1.metaData("y", 257);
        humanTaskNode1.metaData("height", 102);
        org.jbpm.ruleflow.core.factory.HumanTaskNodeFactory<?> humanTaskNode2 = factory.humanTaskNode(2);
        humanTaskNode2.name("Second Line Approval");
        humanTaskNode2.workParameter("TaskName", "secondLineApproval");
        humanTaskNode2.workParameter("Skippable", "true");
        humanTaskNode2.workParameter("GroupId", "managers");
        humanTaskNode2.workParameter("NodeName", "Second Line Approval");
        humanTaskNode2.inMapping("ExcludedOwnerId", "approver");
        humanTaskNode2.inMapping("traveller", "traveller");
        humanTaskNode2.outMapping("approved", "secondLineApproval");
        humanTaskNode2.done();
        humanTaskNode2.metaData("UniqueId", "_0DBFABE8-92B0-46E6-B52E-A9593AFA4371");
        humanTaskNode2.metaData("elementname", "Second Line Approval");
        humanTaskNode2.metaData("x", 689);
        humanTaskNode2.metaData("width", 154);
        humanTaskNode2.metaData("y", 257);
        humanTaskNode2.metaData("height", 102);
        org.jbpm.ruleflow.core.factory.StartNodeFactory<?> startNode3 = factory.startNode(3);
        startNode3.name("StartProcess");
        startNode3.interrupting(true);
        startNode3.metaData("UniqueId", "_9861B686-DF6B-4B1C-B370-F9898EEB47FD");
        startNode3.metaData("elementname", "StartProcess");
        startNode3.metaData("x", 319);
        startNode3.metaData("width", 56);
        startNode3.metaData("y", 280);
        startNode3.metaData("height", 56);
        startNode3.done();
        org.jbpm.ruleflow.core.factory.EndNodeFactory<?> endNode4 = factory.endNode(4);
        endNode4.name("End");
        endNode4.terminate(false);
        endNode4.metaData("UniqueId", "_125D9683-9218-4BBC-94C2-59DDD449ADC6");
        endNode4.metaData("elementname", "End");
        endNode4.metaData("x", 923);
        endNode4.metaData("width", 56);
        endNode4.metaData("y", 280);
        endNode4.metaData("height", 56);
        endNode4.done();
        factory.connection(3, 1, "_9EAFE6C1-69B4-4908-B764-EF3C4A55BEE3");
        factory.connection(1, 2, "_C13522F1-230A-4C26-B5A9-533A5D9FEE9D");
        factory.connection(2, 4, "_078F46FB-B7A1-4DBB-BE9A-75C7CB0CCD03");
        factory.validate();
        return factory.getProcess();
    }
}
