package org.kie.kogito.examples;

import org.kie.kogito.Config;
import org.kie.kogito.process.Processes;
import org.kie.kogito.uow.UnitOfWorkManager;

@javax.inject.Singleton()
public class Application implements org.kie.kogito.Application {

    @javax.inject.Inject()
    javax.enterprise.inject.Instance<org.kie.kogito.event.EventPublisher> eventPublishers;

    @org.eclipse.microprofile.config.inject.ConfigProperty(name = "kogito.service.url")
    java.util.Optional<java.lang.String> kogitoService;

    @javax.inject.Inject()
    org.kie.kogito.Config config;

    RuleUnits ruleUnits = new RuleUnits();

    public Config config() {
        return config;
    }

    public UnitOfWorkManager unitOfWorkManager() {
        return config().process().unitOfWorkManager();
    }

    @javax.annotation.PostConstruct()
    public void setup() {
        if (config().process() != null) {
            if (eventPublishers != null) {
                eventPublishers.forEach(publisher -> unitOfWorkManager().eventManager().addPublisher(publisher));
            }
            unitOfWorkManager().eventManager().setService(kogitoService.orElse(""));
            unitOfWorkManager().eventManager().setAddons(config().addons());
        }
    }

    public RuleUnits ruleUnits() {
        return ruleUnits;
    }

    public class RuleUnits extends org.kie.kogito.rules.units.impl.AbstractRuleUnits {

        org.kie.kogito.rules.KieRuntimeBuilder ruleRuntimeBuilder = new org.drools.project.model.ProjectRuntime();

        public org.kie.kogito.rules.KieRuntimeBuilder ruleRuntimeBuilder() {
            return this.ruleRuntimeBuilder;
        }

        protected org.kie.kogito.rules.RuleUnit<?> create(String fqcn) {
            switch(fqcn) {
                case "org.kie.kogito.queries.LoanUnit":
                    return new org.kie.kogito.queries.LoanUnitRuleUnit(Application.this);
                default:
                    throw new java.lang.UnsupportedOperationException();
            }
        }
    }
}
