/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Objects;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.kie.kogito.explainability.api.BaseExplainabilityRequest;
import org.kie.kogito.explainability.api.CounterfactualSearchDomain;
import org.kie.kogito.explainability.api.ModelIdentifier;
import org.kie.kogito.explainability.api.NamedTypedValue;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CounterfactualExplainabilityRequest
extends BaseExplainabilityRequest {
    public static final String EXPLAINABILITY_TYPE_NAME = "Counterfactual";
    public static final String COUNTERFACTUAL_ID_FIELD = "counterfactualId";
    public static final String COUNTERFACTUAL_ORIGINAL_INPUTS_FIELD = "originalInputs";
    public static final String COUNTERFACTUAL_GOALS_FIELD = "goals";
    public static final String COUNTERFACTUAL_SEARCH_DOMAINS_FIELD = "searchDomains";
    public static final String MAX_RUNNING_TIME_SECONDS_FIELD = "maxRunningTimeSeconds";
    @JsonProperty(value="counterfactualId")
    @NotNull(message="counterfactualId must be provided.")
    private @NotNull(message="counterfactualId must be provided.") String counterfactualId;
    @JsonProperty(value="originalInputs")
    @NotNull(message="originalInputs object must be provided.")
    private @NotNull(message="originalInputs object must be provided.") Collection<NamedTypedValue> originalInputs;
    @JsonProperty(value="goals")
    @NotNull(message="goals object must be provided.")
    private @NotNull(message="goals object must be provided.") Collection<NamedTypedValue> goals;
    @JsonProperty(value="searchDomains")
    @NotNull(message="searchDomains object must be provided.")
    private @NotNull(message="searchDomains object must be provided.") Collection<CounterfactualSearchDomain> searchDomains;
    @JsonProperty(value="maxRunningTimeSeconds")
    @NotNull(message="maxRunningTimeSeconds must be provided.")
    private @NotNull(message="maxRunningTimeSeconds must be provided.") Long maxRunningTimeSeconds;

    public CounterfactualExplainabilityRequest() {
    }

    public CounterfactualExplainabilityRequest(@NotNull String executionId, @NotBlank String serviceUrl, @NotNull ModelIdentifier modelIdentifier, @NotNull String counterfactualId, @NotNull Collection<NamedTypedValue> originalInputs, @NotNull Collection<NamedTypedValue> goals, @NotNull Collection<CounterfactualSearchDomain> searchDomains, Long maxRunningTimeSeconds) {
        super(executionId, serviceUrl, modelIdentifier);
        this.counterfactualId = Objects.requireNonNull(counterfactualId);
        this.originalInputs = Objects.requireNonNull(originalInputs);
        this.goals = Objects.requireNonNull(goals);
        this.searchDomains = Objects.requireNonNull(searchDomains);
        this.maxRunningTimeSeconds = maxRunningTimeSeconds;
    }

    public String getCounterfactualId() {
        return this.counterfactualId;
    }

    public Collection<NamedTypedValue> getOriginalInputs() {
        return this.originalInputs;
    }

    public Collection<NamedTypedValue> getGoals() {
        return this.goals;
    }

    public Collection<CounterfactualSearchDomain> getSearchDomains() {
        return this.searchDomains;
    }

    public Long getMaxRunningTimeSeconds() {
        return this.maxRunningTimeSeconds;
    }
}

