/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.kie.kogito.explainability.api.BaseExplainabilityResultDto;
import org.kie.kogito.explainability.api.ExplainabilityStatus;
import org.kie.kogito.tracing.typedvalue.TypedValue;

public class CounterfactualExplainabilityResultDto
extends BaseExplainabilityResultDto {
    public static final String EXPLAINABILITY_TYPE_NAME = "counterfactual";
    public static final String COUNTERFACTUAL_ID_FIELD = "counterfactualId";
    public static final String IS_VALID_FIELD = "isValid";
    public static final String INPUTS_FIELD = "inputs";
    public static final String OUTPUTS_FIELD = "outputs";
    @JsonProperty(value="counterfactualId")
    @NotNull(message="counterfactualId must be provided.")
    private @NotNull(message="counterfactualId must be provided.") String counterfactualId;
    @JsonProperty(value="isValid")
    private Boolean isValid;
    @JsonProperty(value="inputs")
    private Map<String, TypedValue> inputs;
    @JsonProperty(value="outputs")
    private Map<String, TypedValue> outputs;

    private CounterfactualExplainabilityResultDto() {
    }

    private CounterfactualExplainabilityResultDto(String executionId, String counterfactualId, ExplainabilityStatus status, String statusDetails, boolean isValid, Map<String, TypedValue> inputs, Map<String, TypedValue> outputs) {
        super(executionId, status, statusDetails);
        this.counterfactualId = counterfactualId;
        this.isValid = isValid;
        this.inputs = inputs;
        this.outputs = outputs;
    }

    public static CounterfactualExplainabilityResultDto buildSucceeded(String executionId, String counterfactualId, Boolean isValid, Map<String, TypedValue> inputs, Map<String, TypedValue> outputs) {
        return new CounterfactualExplainabilityResultDto(executionId, counterfactualId, ExplainabilityStatus.SUCCEEDED, null, isValid, inputs, outputs);
    }

    public static CounterfactualExplainabilityResultDto buildFailed(String executionId, String counterfactualId, String statusDetails) {
        return new CounterfactualExplainabilityResultDto(executionId, counterfactualId, ExplainabilityStatus.FAILED, statusDetails, Boolean.FALSE, Collections.emptyMap(), Collections.emptyMap());
    }

    public String getCounterfactualId() {
        return this.counterfactualId;
    }

    public Boolean getValid() {
        return this.isValid;
    }

    public Map<String, TypedValue> getInputs() {
        return this.inputs;
    }

    public Map<String, TypedValue> getOutputs() {
        return this.outputs;
    }
}

