/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.kie.kogito.explainability.api.BaseExplainabilityResultDto;
import org.kie.kogito.explainability.api.ExplainabilityStatus;
import org.kie.kogito.tracing.typedvalue.TypedValue;

public class CounterfactualExplainabilityResultDto
extends BaseExplainabilityResultDto {
    public static final String EXPLAINABILITY_TYPE_NAME = "counterfactual";
    public static final String COUNTERFACTUAL_ID_FIELD = "counterfactualId";
    public static final String SOLUTION_ID_FIELD = "solutionId";
    public static final String IS_VALID_FIELD = "isValid";
    public static final String STAGE_FIELD = "stage";
    public static final String INPUTS_FIELD = "inputs";
    public static final String OUTPUTS_FIELD = "outputs";
    @JsonProperty(value="counterfactualId")
    @NotNull(message="counterfactualId must be provided.")
    private @NotNull(message="counterfactualId must be provided.") String counterfactualId;
    @JsonProperty(value="solutionId")
    @NotNull(message="solutionId must be provided.")
    private @NotNull(message="solutionId must be provided.") String solutionId;
    @JsonProperty(value="isValid")
    @NotNull(message="isValid must be provided.")
    private @NotNull(message="isValid must be provided.") Boolean isValid;
    @JsonProperty(value="stage")
    @NotNull(message="stage must be provided.")
    private @NotNull(message="stage must be provided.") Stage stage;
    @JsonProperty(value="inputs")
    @NotNull(message="inputs object must be provided.")
    private @NotNull(message="inputs object must be provided.") Map<String, TypedValue> inputs;
    @JsonProperty(value="outputs")
    @NotNull(message="outputs object must be provided.")
    private @NotNull(message="outputs object must be provided.") Map<String, TypedValue> outputs;

    private CounterfactualExplainabilityResultDto() {
    }

    private CounterfactualExplainabilityResultDto(@NotNull String executionId, @NotNull String counterfactualId, @NotNull String solutionId, @NotNull ExplainabilityStatus status, String statusDetails, @NotNull Boolean isValid, @NotNull Stage stage, @NotNull Map<String, TypedValue> inputs, @NotNull Map<String, TypedValue> outputs) {
        super(executionId, status, statusDetails);
        this.counterfactualId = Objects.requireNonNull(counterfactualId);
        this.solutionId = Objects.requireNonNull(solutionId);
        this.isValid = Objects.requireNonNull(isValid);
        this.stage = Objects.requireNonNull(stage);
        this.inputs = Objects.requireNonNull(inputs);
        this.outputs = Objects.requireNonNull(outputs);
    }

    public static CounterfactualExplainabilityResultDto buildSucceeded(String executionId, String counterfactualId, String solutionId, Boolean isValid, Stage stage, Map<String, TypedValue> inputs, Map<String, TypedValue> outputs) {
        return new CounterfactualExplainabilityResultDto(executionId, counterfactualId, solutionId, ExplainabilityStatus.SUCCEEDED, null, isValid, stage, inputs, outputs);
    }

    public static CounterfactualExplainabilityResultDto buildFailed(String executionId, String counterfactualId, String statusDetails) {
        return new CounterfactualExplainabilityResultDto(executionId, counterfactualId, UUID.randomUUID().toString(), ExplainabilityStatus.FAILED, statusDetails, Boolean.FALSE, Stage.FINAL, Collections.emptyMap(), Collections.emptyMap());
    }

    public String getCounterfactualId() {
        return this.counterfactualId;
    }

    public String getSolutionId() {
        return this.solutionId;
    }

    public Boolean isValid() {
        return this.isValid;
    }

    public Stage getStage() {
        return this.stage;
    }

    public Map<String, TypedValue> getInputs() {
        return this.inputs;
    }

    public Map<String, TypedValue> getOutputs() {
        return this.outputs;
    }

    public static enum Stage {
        INTERMEDIATE,
        FINAL;

    }
}

