/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.handlers;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.kie.kogito.explainability.api.BaseExplainabilityRequestDto;
import org.kie.kogito.explainability.api.BaseExplainabilityResultDto;
import org.kie.kogito.explainability.local.LocalExplainer;
import org.kie.kogito.explainability.model.Prediction;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.models.BaseExplainabilityRequest;

public interface LocalExplainerServiceHandler<T, R extends BaseExplainabilityRequest, D extends BaseExplainabilityRequestDto>
extends LocalExplainer<T> {
    public <U extends BaseExplainabilityRequest> boolean supports(Class<U> var1);

    public <U extends BaseExplainabilityRequestDto> boolean supportsDto(Class<U> var1);

    public R explainabilityRequestFrom(D var1);

    public Prediction getPrediction(R var1);

    public PredictionProvider getPredictionProvider(R var1);

    default public CompletableFuture<BaseExplainabilityResultDto> explainAsyncWithResults(R request, Consumer<BaseExplainabilityResultDto> intermediateResultsConsumer) {
        Prediction prediction = this.getPrediction(request);
        PredictionProvider predictionProvider = this.getPredictionProvider(request);
        return ((CompletableFuture)this.explainAsync(prediction, predictionProvider, s -> intermediateResultsConsumer.accept(this.createIntermediateResultDto(request, s))).thenApply(input -> this.createSucceededResultDto(request, input))).exceptionally(e -> this.createFailedResultDto(request, (Throwable)e));
    }

    public BaseExplainabilityResultDto createSucceededResultDto(R var1, T var2);

    public BaseExplainabilityResultDto createFailedResultDto(R var1, Throwable var2);

    public BaseExplainabilityResultDto createIntermediateResultDto(R var1, T var2);
}

