/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.kie.kogito.explainability.api.CounterfactualDomain;
import org.kie.kogito.explainability.api.CounterfactualDomainCategorical;
import org.kie.kogito.explainability.api.CounterfactualDomainRange;
import org.kie.kogito.explainability.api.CounterfactualSearchDomain;
import org.kie.kogito.explainability.api.CounterfactualSearchDomainUnitValue;
import org.kie.kogito.explainability.api.CounterfactualSearchDomainValue;
import org.kie.kogito.explainability.api.HasNameValue;
import org.kie.kogito.explainability.api.NamedTypedValue;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.Output;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.explainability.model.domain.CategoricalFeatureDomain;
import org.kie.kogito.explainability.model.domain.EmptyFeatureDomain;
import org.kie.kogito.explainability.model.domain.FeatureDomain;
import org.kie.kogito.explainability.model.domain.NumericalFeatureDomain;
import org.kie.kogito.tracing.typedvalue.CollectionValue;
import org.kie.kogito.tracing.typedvalue.StructureValue;
import org.kie.kogito.tracing.typedvalue.TypedValue;
import org.kie.kogito.tracing.typedvalue.UnitValue;

public class ConversionUtils {
    public static List<Feature> toFeatureList(Collection<? extends HasNameValue<TypedValue>> values) {
        return ConversionUtils.toList(values, ConversionUtils::toFeature);
    }

    static Feature toFeature(HasNameValue<TypedValue> hnv) {
        return ConversionUtils.toFeature(hnv.getName(), (TypedValue)hnv.getValue());
    }

    static Feature toFeature(String name, TypedValue value) {
        if (value.isUnit()) {
            return ConversionUtils.toTypeValuePair(((UnitValue)value.toUnit()).getValue()).map(p -> new Feature(name, (Type)p.getLeft(), (Value)p.getRight())).orElse(null);
        }
        if (value.isStructure()) {
            return FeatureFactory.newCompositeFeature((String)name, ConversionUtils.toFeatureList(((StructureValue)value.toStructure()).getValue()));
        }
        if (value.isCollection()) {
            return FeatureFactory.newCompositeFeature((String)name, ConversionUtils.toFeatureList(name, (CollectionValue)value.toCollection()));
        }
        throw new IllegalArgumentException(String.format("unexpected value kind %s", value.getKind()));
    }

    static List<Feature> toFeatureList(Map<String, TypedValue> values) {
        return ConversionUtils.toList(values, ConversionUtils::toFeature);
    }

    static List<Feature> toFeatureList(String name, CollectionValue collectionValue) {
        Collection values = collectionValue.getValue();
        ArrayList<Feature> list = new ArrayList<Feature>(values.size());
        int index = 0;
        for (TypedValue typedValue : values) {
            list.add(ConversionUtils.toFeature(name + "_" + index, typedValue));
            ++index;
        }
        return list;
    }

    public static List<Output> toOutputList(Collection<? extends HasNameValue<TypedValue>> values) {
        return ConversionUtils.toList(values, (T hnv) -> ConversionUtils.toOutput(hnv.getName(), (TypedValue)hnv.getValue()));
    }

    static Output toOutput(String name, TypedValue value) {
        if (value.isUnit()) {
            return ConversionUtils.toTypeValuePair(((UnitValue)value.toUnit()).getValue()).map(p -> new Output(name, (Type)p.getLeft(), (Value)p.getRight(), 1.0)).orElse(null);
        }
        if (value.isStructure()) {
            return new Output(name, Type.COMPOSITE, new Value(ConversionUtils.toOutputListForStructure(((StructureValue)value.toStructure()).getValue())), 1.0);
        }
        if (value.isCollection()) {
            return new Output(name, Type.COMPOSITE, new Value(ConversionUtils.toOutputListForCollection(name, (CollectionValue)value.toCollection())), 1.0);
        }
        return null;
    }

    static Optional<Pair<Type, Value>> toTypeValuePair(JsonNode jsonValue) {
        if (jsonValue.isBoolean()) {
            return Optional.of(Pair.of((Object)Type.BOOLEAN, (Object)new Value((Object)jsonValue.asBoolean())));
        }
        if (jsonValue.isNumber()) {
            return Optional.of(Pair.of((Object)Type.NUMBER, (Object)new Value((Object)jsonValue.asDouble())));
        }
        if (jsonValue.isTextual()) {
            return Optional.of(Pair.of((Object)Type.TEXT, (Object)new Value((Object)jsonValue.asText())));
        }
        return Optional.empty();
    }

    static List<Output> toOutputListForStructure(Map<String, TypedValue> values) {
        return ConversionUtils.toList(values, ConversionUtils::toOutput);
    }

    static List<Output> toOutputListForCollection(String name, CollectionValue collectionValue) {
        Collection values = collectionValue.getValue();
        ArrayList<Output> list = new ArrayList<Output>(values.size());
        int index = 0;
        for (TypedValue typedValue : values) {
            list.add(ConversionUtils.toOutput(name + "_" + index, typedValue));
            ++index;
        }
        return list;
    }

    public static List<FeatureDomain> toFeatureDomainList(Collection<CounterfactualSearchDomain> searchDomains) {
        return ConversionUtils.toList(searchDomains, (T hnv) -> ConversionUtils.toFeatureDomain(hnv.getValue()));
    }

    public static FeatureDomain toFeatureDomain(CounterfactualSearchDomainValue domain) {
        if (domain.isUnit()) {
            return ConversionUtils.toCounterfactualSearchDomain(((CounterfactualSearchDomainUnitValue)domain.toUnit()).getDomain()).orElseThrow(() -> new IllegalArgumentException(String.format("Unsupported CounterfactualSearchDomain type %s", domain.getClass().getName())));
        }
        throw new IllegalArgumentException(String.format("Unsupported CounterfactualSearchDomain kind %s", domain.getKind()));
    }

    static Optional<FeatureDomain> toCounterfactualSearchDomain(CounterfactualDomain domain) {
        if (Objects.isNull(domain)) {
            return Optional.of(EmptyFeatureDomain.create());
        }
        if (domain instanceof CounterfactualDomainRange) {
            CounterfactualDomainRange range = (CounterfactualDomainRange)domain;
            JsonNode lb = range.getLowerBound();
            JsonNode ub = range.getUpperBound();
            if (lb.isNumber() && ub.isNumber()) {
                return Optional.of(NumericalFeatureDomain.create((double)range.getLowerBound().asDouble(), (double)range.getUpperBound().asDouble()));
            }
            throw new IllegalArgumentException(String.format("Unsupported CounterfactualDomainRange [%s, %s]", lb.asText(), ub.asText()));
        }
        if (domain instanceof CounterfactualDomainCategorical) {
            CounterfactualDomainCategorical categorical = (CounterfactualDomainCategorical)domain;
            Collection jsonCategories = categorical.getCategories();
            CharSequence[] categories = new String[jsonCategories.size()];
            if (jsonCategories.stream().allMatch(JsonNode::isTextual)) {
                jsonCategories.stream().map(JsonNode::asText).collect(Collectors.toList()).toArray(categories);
                return Optional.of(CategoricalFeatureDomain.create((String[])categories));
            }
            throw new IllegalArgumentException(String.format("Unsupported CounterfactualDomainCategorical [%s]", String.join((CharSequence)", ", categories)));
        }
        return Optional.empty();
    }

    public static List<Boolean> toFeatureConstraintList(Collection<CounterfactualSearchDomain> searchDomains) {
        return ConversionUtils.toList(searchDomains, (T hnv) -> ConversionUtils.toFeatureConstraint(hnv.getValue()));
    }

    static Boolean toFeatureConstraint(CounterfactualSearchDomainValue domain) {
        if (domain.isUnit()) {
            return ((CounterfactualSearchDomainUnitValue)domain.toUnit()).isFixed();
        }
        throw new IllegalArgumentException(String.format("Unsupported CounterfactualSearchDomain kind %s", domain.getKind()));
    }

    public static List<Output> toOutputList(JsonObject mainObj) {
        return ConversionUtils.toList(mainObj, ConversionUtils::toOutput);
    }

    static Output toOutput(String name, Object value) {
        if (value instanceof JsonObject) {
            return new Output(name, Type.COMPOSITE, new Value(ConversionUtils.toOutputList((JsonObject)value)), 1.0);
        }
        return ConversionUtils.toTypeValuePair(value).map(p -> new Output(name, (Type)p.getLeft(), (Value)p.getRight(), 1.0)).orElse(null);
    }

    static Optional<Pair<Type, Value>> toTypeValuePair(Object value) {
        if (value instanceof Boolean) {
            return Optional.of(Pair.of((Object)Type.BOOLEAN, (Object)new Value(value)));
        }
        if (value instanceof Number) {
            return Optional.of(Pair.of((Object)Type.NUMBER, (Object)new Value((Object)((Number)value).doubleValue())));
        }
        if (value instanceof String) {
            return Optional.of(Pair.of((Object)Type.TEXT, (Object)new Value(value)));
        }
        return Optional.empty();
    }

    static <R, T> List<R> toList(Collection<T> values, Function<T, R> unitConverter) {
        if (values == null) {
            return Collections.emptyList();
        }
        return values.stream().map(unitConverter).filter(Objects::nonNull).collect(Collectors.toList());
    }

    static <T, V> List<T> toList(Map<String, V> values, BiFunction<String, V, T> unitConverter) {
        if (values == null) {
            return Collections.emptyList();
        }
        return values.entrySet().stream().map(entry -> unitConverter.apply((String)entry.getKey(), entry.getValue())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    static <T> List<T> toList(JsonObject mainObj, BiFunction<String, Object, T> unitConverter) {
        if (mainObj == null) {
            return Collections.emptyList();
        }
        return mainObj.stream().map(entry -> unitConverter.apply((String)entry.getKey(), entry.getValue())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<NamedTypedValue> fromFeatureList(List<Feature> features) {
        return ConversionUtils.toList(features, (T f) -> new NamedTypedValue(f.getName(), ConversionUtils.toTypedValue(f)));
    }

    static TypedValue toTypedValue(Feature feature) {
        String name = feature.getName();
        Type type = feature.getType();
        Value value = feature.getValue();
        return ConversionUtils.toTypedValue(name, type, value);
    }

    static TypedValue toTypedValue(String name, Type type, Value value) {
        Object underlyingObject = value.getUnderlyingObject();
        if (type.equals((Object)Type.BOOLEAN)) {
            if (underlyingObject instanceof Boolean) {
                return new UnitValue(Boolean.class.getSimpleName(), (JsonNode)BooleanNode.valueOf((boolean)((Boolean)underlyingObject)));
            }
        } else if (type.equals((Object)Type.NUMBER)) {
            if (underlyingObject instanceof Double) {
                return new UnitValue(Double.class.getSimpleName(), (JsonNode)new DoubleNode(((Double)underlyingObject).doubleValue()));
            }
        } else if (type.equals((Object)Type.TEXT) && underlyingObject instanceof String) {
            return new UnitValue(String.class.getSimpleName(), (JsonNode)new TextNode((String)underlyingObject));
        }
        throw new IllegalArgumentException(String.format("Unable to convert '%s' with Type '%s' and Value '%s'", name, type, value));
    }

    public static List<NamedTypedValue> fromOutputs(List<Output> outputs) {
        return ConversionUtils.toList(outputs, (T o) -> new NamedTypedValue(o.getName(), ConversionUtils.toTypedValue(o)));
    }

    static TypedValue toTypedValue(Output output) {
        String name = output.getName();
        Type type = output.getType();
        Value value = output.getValue();
        return ConversionUtils.toTypedValue(name, type, value);
    }
}

