/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.handlers;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.kie.kogito.explainability.api.BaseExplainabilityRequest;
import org.kie.kogito.explainability.api.BaseExplainabilityResult;
import org.kie.kogito.explainability.local.LocalExplainer;
import org.kie.kogito.explainability.model.Prediction;
import org.kie.kogito.explainability.model.PredictionProvider;

public interface LocalExplainerServiceHandler<T, R extends BaseExplainabilityRequest>
extends LocalExplainer<T> {
    public <U extends BaseExplainabilityRequest> boolean supports(Class<U> var1);

    public Prediction getPrediction(R var1);

    public PredictionProvider getPredictionProvider(R var1);

    default public CompletableFuture<BaseExplainabilityResult> explainAsyncWithResults(R request, Consumer<BaseExplainabilityResult> intermediateResultsConsumer) {
        Prediction prediction = this.getPrediction(request);
        PredictionProvider predictionProvider = this.getPredictionProvider(request);
        return ((CompletableFuture)this.explainAsync(prediction, predictionProvider, s -> intermediateResultsConsumer.accept(this.createIntermediateResult(request, s))).thenApply(input -> this.createSucceededResult(request, input))).exceptionally(e -> this.createFailedResult(request, (Throwable)e));
    }

    public BaseExplainabilityResult createSucceededResult(R var1, T var2);

    public BaseExplainabilityResult createFailedResult(R var1, Throwable var2);

    public BaseExplainabilityResult createIntermediateResult(R var1, T var2);
}

