/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.handlers;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.kie.kogito.explainability.api.BaseExplainabilityRequestDto;
import org.kie.kogito.explainability.api.BaseExplainabilityResultDto;
import org.kie.kogito.explainability.handlers.LocalExplainerServiceHandler;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.models.BaseExplainabilityRequest;

@ApplicationScoped
public class LocalExplainerServiceHandlerRegistry {
    public static final String SERVICE_HANDLER_NOT_FOUND_ERROR_MESSAGE = "LocalExplainerServiceHandler could not be found for '%s'";
    private Instance<LocalExplainerServiceHandler<?, ?, ?>> explanationHandlers;

    protected LocalExplainerServiceHandlerRegistry() {
    }

    @Inject
    public LocalExplainerServiceHandlerRegistry(@Any Instance<LocalExplainerServiceHandler<?, ?, ?>> explanationHandlers) {
        this.explanationHandlers = explanationHandlers;
    }

    public <R extends BaseExplainabilityRequest, D extends BaseExplainabilityRequestDto> R explainabilityRequestFrom(D dto) {
        LocalExplainerServiceHandler<?, ?, ?> explanationHandler = this.getLocalExplainerDto(dto.getClass()).orElseThrow(() -> new IllegalArgumentException(String.format(SERVICE_HANDLER_NOT_FOUND_ERROR_MESSAGE, dto.getClass().getName())));
        return (R)this.cast((BaseExplainabilityRequest)explanationHandler.explainabilityRequestFrom(this.castDto(dto)));
    }

    public <R extends BaseExplainabilityRequest> CompletableFuture<BaseExplainabilityResultDto> explainAsyncWithResults(R request, PredictionProvider model) {
        LocalExplainerServiceHandler<?, ?, ?> explanationHandler = this.getLocalExplainer(request.getClass()).orElseThrow(() -> new IllegalArgumentException(String.format(SERVICE_HANDLER_NOT_FOUND_ERROR_MESSAGE, request.getClass().getName())));
        try {
            return explanationHandler.explainAsyncWithResults(this.cast(request), model);
        }
        catch (Exception e) {
            return CompletableFuture.completedFuture(explanationHandler.createFailedResultDto(this.cast(request), e));
        }
    }

    private <T extends BaseExplainabilityRequest> Optional<LocalExplainerServiceHandler<?, ?, ?>> getLocalExplainer(Class<T> type) {
        return this.explanationHandlers.stream().filter(explainer -> explainer.supports(type)).findFirst();
    }

    private <T extends BaseExplainabilityRequestDto> Optional<LocalExplainerServiceHandler<?, ?, ?>> getLocalExplainerDto(Class<T> type) {
        return this.explanationHandlers.stream().filter(explainer -> explainer.supportsDto(type)).findFirst();
    }

    private <T extends BaseExplainabilityRequest> T cast(BaseExplainabilityRequest type) {
        return (T)type;
    }

    private <T extends BaseExplainabilityRequestDto> T castDto(BaseExplainabilityRequestDto type) {
        return (T)type;
    }
}

