/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability;

import java.util.List;
import org.kie.kogito.Application;
import org.kie.kogito.explainability.ExplainabilityService;
import org.kie.kogito.explainability.model.PredictInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/predict"})
public class SpringBootExplainableResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringBootExplainableResource.class);
    private static final ExplainabilityService explainabilityService = ExplainabilityService.INSTANCE;
    private final Application application;

    @Autowired
    public SpringBootExplainableResource(Application application) {
        this.application = application;
    }

    @PostMapping(consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity predict(@RequestBody List<PredictInput> inputs) {
        try {
            return ResponseEntity.ok((Object)explainabilityService.processRequest(this.application, inputs));
        }
        catch (Exception e) {
            LOGGER.warn("An Exception occurred processing the predict request", (Throwable)e);
            return ResponseEntity.badRequest().body((Object)e.getMessage());
        }
    }
}

