/*
 * Decompiled with CFR 0.152.
 */
package org.kie.flexible.kogito.example.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.flexible.kogito.example.model.Comment;
import org.kie.flexible.kogito.example.model.Product;
import org.kie.flexible.kogito.example.model.Questionnaire;
import org.kie.flexible.kogito.example.model.State;

public class SupportCase {
    private Product product;
    private String description;
    private String engineer;
    private String customer;
    private State state = State.NEW;
    private List<Comment> comments;
    private Questionnaire questionnaire;

    public SupportCase() {
    }

    public SupportCase(SupportCase supportCase) {
        this.customer = supportCase.customer;
        this.product = new Product(supportCase.product);
        this.engineer = supportCase.engineer;
        this.state = supportCase.state;
        this.description = supportCase.description;
        if (supportCase.comments != null) {
            this.comments = supportCase.comments.stream().map(Comment::new).collect(Collectors.toList());
        }
        if (supportCase.questionnaire != null) {
            this.questionnaire = new Questionnaire(supportCase.questionnaire);
        }
    }

    public Product getProduct() {
        return this.product;
    }

    public SupportCase setProduct(Product product) {
        this.product = product;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public SupportCase setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getEngineer() {
        return this.engineer;
    }

    public SupportCase setEngineer(String engineer) {
        this.engineer = engineer;
        return this;
    }

    public String getCustomer() {
        return this.customer;
    }

    public SupportCase setCustomer(String customer) {
        this.customer = customer;
        return this;
    }

    public State getState() {
        return this.state;
    }

    public SupportCase setState(State state) {
        this.state = state;
        return this;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public SupportCase addComment(Comment comment) {
        if (this.comments == null) {
            this.comments = new ArrayList<Comment>();
        }
        this.comments.add(comment);
        return this;
    }

    public Questionnaire getQuestionnaire() {
        return this.questionnaire;
    }

    public SupportCase setQuestionnaire(Questionnaire questionnaire) {
        this.questionnaire = questionnaire;
        return this;
    }

    public String toString() {
        return "SupportCase{product=" + this.product + ", description='" + this.description + "', engineer='" + this.engineer + "', customer='" + this.customer + "', state=" + this.state + ", comments=" + this.comments + ", questionnaire=" + this.questionnaire + "}";
    }
}

