/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.grafana;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import org.kie.dmn.model.api.Decision;
import org.kie.kogito.grafana.JGrafana;
import org.kie.kogito.grafana.dmn.SupportedDecisionTypes;
import org.kie.kogito.grafana.model.panel.PanelType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrafanaConfigurationWriter {
    private static final Logger logger = LoggerFactory.getLogger(GrafanaConfigurationWriter.class);

    private GrafanaConfigurationWriter() {
    }

    public static String generateDashboardForEndpoint(String templatePath, String handlerName) {
        String template = GrafanaConfigurationWriter.readStandardDashboard(templatePath);
        return GrafanaConfigurationWriter.customizeTemplate(template, handlerName);
    }

    public static String generateDashboardForDMNEndpoint(String templatePath, String endpoint, List<Decision> decisions) {
        JGrafana jgrafana;
        String template = GrafanaConfigurationWriter.readStandardDashboard(templatePath);
        template = GrafanaConfigurationWriter.customizeTemplate(template, endpoint);
        try {
            jgrafana = JGrafana.parse(template);
        }
        catch (IOException e) {
            logger.warn("Could not read the grafana dashboard template.", (Throwable)e);
            return null;
        }
        for (Decision decision : decisions) {
            String type = decision.getVariable().getTypeRef().getLocalPart();
            if (!SupportedDecisionTypes.isSupported(type)) continue;
            jgrafana.addPanel(PanelType.GRAPH, "Decision " + decision.getName(), String.format("%s_dmn_result{endpoint = \"%s\", decision = \"%s\"}", type, endpoint, decision.getName()), SupportedDecisionTypes.getGrafanaFunction(type));
        }
        try {
            return jgrafana.serialize();
        }
        catch (IOException e) {
            logger.warn("Could not serialize the grafana dashboard template.", (Throwable)e);
            return null;
        }
    }

    private static String readStandardDashboard(String templatePath) {
        InputStream is = GrafanaConfigurationWriter.class.getResourceAsStream(templatePath);
        return new BufferedReader(new InputStreamReader(is)).lines().collect(Collectors.joining("\n"));
    }

    private static String customizeTemplate(String template, String handlerName) {
        template = template.replaceAll("\\$handlerName\\$", handlerName);
        template = template.replaceAll("\\$id\\$", String.valueOf(new Random().nextInt()));
        template = template.replaceAll("\\$uid\\$", UUID.randomUUID().toString());
        return template;
    }
}

