/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.grafana.dmn;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.kie.kogito.grafana.dmn.AbstractDmnType;
import org.kie.kogito.grafana.dmn.BooleanType;
import org.kie.kogito.grafana.dmn.NumberType;
import org.kie.kogito.grafana.dmn.StringType;
import org.kie.kogito.grafana.model.functions.GrafanaFunction;

public class SupportedDecisionTypes {
    private static final Set<AbstractDmnType> supportedDmnTypes = new HashSet<AbstractDmnType>();
    private static final Map<Class, String> dmnInternalClassToDmnStandardMap = new HashMap<Class, String>();

    private SupportedDecisionTypes() {
    }

    public static boolean isSupported(String type) {
        return dmnInternalClassToDmnStandardMap.containsValue(type);
    }

    public static boolean isSupported(Class c) {
        return dmnInternalClassToDmnStandardMap.containsKey(c);
    }

    public static String fromInternalToStandard(Class c) {
        return dmnInternalClassToDmnStandardMap.get(c);
    }

    public static SortedMap<Integer, GrafanaFunction> getGrafanaFunction(String dmnType) {
        Optional<AbstractDmnType> type;
        if (SupportedDecisionTypes.isSupported(dmnType) && (type = supportedDmnTypes.stream().filter(x -> x.getDmnType().equalsIgnoreCase(dmnType)).findFirst()).isPresent()) {
            return type.get().getGrafanaFunctions();
        }
        return new TreeMap<Integer, GrafanaFunction>();
    }

    public static Collection<String> getSupportedDMNTypes() {
        return dmnInternalClassToDmnStandardMap.values();
    }

    static {
        supportedDmnTypes.add(new BooleanType());
        supportedDmnTypes.add(new NumberType());
        supportedDmnTypes.add(new StringType());
        supportedDmnTypes.stream().forEach(x -> dmnInternalClassToDmnStandardMap.put(x.getInternalClass(), x.getDmnType()));
    }
}

