/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.grafana;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.SortedMap;
import java.util.UUID;
import org.kie.kogito.grafana.factories.GridPosFactory;
import org.kie.kogito.grafana.factories.PanelFactory;
import org.kie.kogito.grafana.model.GrafanaDashboard;
import org.kie.kogito.grafana.model.functions.ExprBuilder;
import org.kie.kogito.grafana.model.functions.GrafanaFunction;
import org.kie.kogito.grafana.model.panel.GrafanaPanel;
import org.kie.kogito.grafana.model.panel.PanelType;

public class JGrafana {
    private GrafanaDashboard dashboard;

    public JGrafana(String title) {
        this(title, UUID.randomUUID().toString());
    }

    public JGrafana(String title, String uuid) {
        this.dashboard = new GrafanaDashboard(null, uuid, title);
    }

    public JGrafana(GrafanaDashboard dashboard) {
        this.dashboard = dashboard;
    }

    public static JGrafana parse(String dashboard) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        GrafanaDashboard dash = (GrafanaDashboard)mapper.readValue(dashboard, GrafanaDashboard.class);
        for (int i = 0; i < dash.panels.size(); ++i) {
            GrafanaPanel p = dash.panels.get(i);
            p.id = i + 1;
            p.gridPos = GridPosFactory.calculateGridPosById(i + 1);
        }
        return new JGrafana(dash);
    }

    public GrafanaDashboard getDashboard() {
        return this.dashboard;
    }

    public GrafanaPanel addPanel(PanelType type, String title, String expr) {
        return this.addPanel(type, title, expr, null);
    }

    public boolean removePanelByTitle(String title) {
        return this.dashboard.panels.removeIf(x -> x.title.equals(title));
    }

    public GrafanaPanel addPanel(PanelType type, String title, String expr, SortedMap<Integer, GrafanaFunction> functions) {
        int id = this.dashboard.panels.size() + 1;
        if (functions != null && functions.size() != 0) {
            expr = ExprBuilder.apply(expr, functions);
        }
        GrafanaPanel panel = PanelFactory.createPanel(type, id, title, expr);
        this.dashboard.panels.add(panel);
        return panel;
    }

    public GrafanaPanel getPanelByTitle(String title) {
        Optional<GrafanaPanel> panel = this.dashboard.panels.stream().filter(x -> x.title.equals(title)).findFirst();
        if (!panel.isPresent()) {
            throw new NoSuchElementException(String.format("There is no panel with title \"%s\"", title));
        }
        return panel.get();
    }

    public void writeToFile(File file) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.writer((PrettyPrinter)new DefaultPrettyPrinter());
        mapper.writeValue(file, (Object)this.dashboard);
    }

    public String serialize() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)this.dashboard);
    }
}

